/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.authentication.http.basic.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.everit.osgi.authentication.context.AuthenticationPropagator;
import org.everit.osgi.authentication.http.basic.internal.HttpBasicAuthFilter;
import org.everit.osgi.authenticator.Authenticator;
import org.everit.osgi.resource.resolver.ResourceIdResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.log.LogService;

@Component(name="org.everit.osgi.authentication.http.basic.HttpBasicAuthenticationFilter", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="filterName", value={"HttpBasicAuthenticationFilter"}), @Property(name="pattern", value={"/*"}), @Property(name="contextId", value={"defaultContext"}), @Property(name="ranking", value={"0"}), @Property(name="realm", value={"my-realm"}), @Property(name="authenticator.target"), @Property(name="resourceIdResolver.target"), @Property(name="authenticationPropagator.target"), @Property(name="logService.target")})
public class HttpBasicAuthFilterComponent {
    @Reference(bind="setAuthenticator")
    private Authenticator authenticator;
    @Reference(bind="setResourceIdResolver")
    private ResourceIdResolver resourceIdResolver;
    @Reference(bind="setAuthenticationPropagator")
    private AuthenticationPropagator authenticationPropagator;
    @Reference(bind="setLogService")
    private LogService logService;
    private ServiceRegistration<Filter> httpBasicAuthFilterSR;

    @Activate
    public void activate(BundleContext context, Map<String, Object> componentProperties) throws Exception {
        String realm = this.getStringProperty(componentProperties, "realm");
        String filterName = this.getStringProperty(componentProperties, "filterName");
        String pattern = this.getStringProperty(componentProperties, "pattern");
        String contextId = this.getStringProperty(componentProperties, "contextId");
        Long ranking = Long.valueOf(this.getStringProperty(componentProperties, "ranking"));
        HttpBasicAuthFilter httpBasicAuthFilter = new HttpBasicAuthFilter(this.authenticator, this.resourceIdResolver, this.authenticationPropagator, realm, this.logService);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("filterName", filterName);
        ((Dictionary)properties).put("pattern", pattern);
        ((Dictionary)properties).put("contextId", contextId);
        ((Dictionary)properties).put("service.ranking", ranking);
        this.httpBasicAuthFilterSR = context.registerService(Filter.class, (Object)httpBasicAuthFilter, properties);
    }

    @Deactivate
    public void deactivate() {
        if (this.httpBasicAuthFilterSR != null) {
            this.httpBasicAuthFilterSR.unregister();
            this.httpBasicAuthFilterSR = null;
        }
    }

    private String getStringProperty(Map<String, Object> componentProperties, String propertyName) throws ConfigurationException {
        Object value = componentProperties.get(propertyName);
        if (value == null) {
            throw new ConfigurationException(propertyName, "property not defined");
        }
        return String.valueOf(value);
    }

    public void setAuthenticationPropagator(AuthenticationPropagator authenticationPropagator) {
        this.authenticationPropagator = authenticationPropagator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    protected void unbindAuthenticator(Authenticator authenticator) {
        if (this.authenticator == authenticator) {
            this.authenticator = null;
        }
    }

    protected void unbindResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        if (this.resourceIdResolver == resourceIdResolver) {
            this.resourceIdResolver = null;
        }
    }

    protected void unbindAuthenticationPropagator(AuthenticationPropagator authenticationPropagator) {
        if (this.authenticationPropagator == authenticationPropagator) {
            this.authenticationPropagator = null;
        }
    }

    protected void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }
}

