/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.authentication.http.basic.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everit.osgi.authentication.context.AuthenticationPropagator;
import org.everit.osgi.authenticator.Authenticator;
import org.everit.osgi.resource.resolver.ResourceIdResolver;
import org.osgi.service.log.LogService;

public class HttpBasicAuthFilter
implements Filter {
    private static final String CLIENT_HEADER_AUTHORIZATION = "Authorization";
    private static final String CLEENT_HEADER_VALUE_PREFIX = "Basic ";
    private static final String SERVER_HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String SERVER_HEADER_VALUE = "Basic realm=\"%1$s\"";
    private static final String USERNAME_PASSWORD_SEPARATOR = ":";
    private final Authenticator authenticator;
    private final ResourceIdResolver resourceIdResolver;
    private final AuthenticationPropagator authenticationPropagator;
    private final LogService logService;
    private final String realm;

    public HttpBasicAuthFilter(Authenticator authenticator, ResourceIdResolver resourceIdResolver, AuthenticationPropagator authenticationPropagator, String realm, LogService logService) {
        this.authenticator = authenticator;
        this.resourceIdResolver = resourceIdResolver;
        this.authenticationPropagator = authenticationPropagator;
        this.realm = realm;
        this.logService = logService;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String password;
        byte[] decodedUsernamePassword;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String authorizationHeader = httpServletRequest.getHeader(CLIENT_HEADER_AUTHORIZATION);
        if (authorizationHeader == null) {
            this.logService.log(3, "Missing header parameter 'Authorization'.");
            this.requestForAuthentication(response);
            return;
        }
        if (!authorizationHeader.startsWith(CLEENT_HEADER_VALUE_PREFIX)) {
            this.logService.log(3, "Invalid value for header parameter 'Authorization'.");
            this.requestForAuthentication(response);
            return;
        }
        String authorizationBase64 = authorizationHeader.substring(CLEENT_HEADER_VALUE_PREFIX.length());
        Base64.Decoder mimeDecoder = Base64.getMimeDecoder();
        try {
            decodedUsernamePassword = mimeDecoder.decode(authorizationBase64);
        }
        catch (IllegalArgumentException e) {
            this.logService.log(3, "Invalid BASE64 value for 'Authorization' header paramter.");
            this.requestForAuthentication(response);
            return;
        }
        String usernamePassword = new String(decodedUsernamePassword, StandardCharsets.UTF_8);
        int separatorIndex = usernamePassword.indexOf(USERNAME_PASSWORD_SEPARATOR);
        if (separatorIndex == -1) {
            this.logService.log(3, "Username and password separator ':' does not exists in header parameter 'Authorization'.");
            this.requestForAuthentication(response);
            return;
        }
        String username = usernamePassword.substring(0, separatorIndex);
        Optional optionalAuthenticatedPrincipal = this.authenticator.authenticate(username, password = usernamePassword.substring(separatorIndex + 1));
        if (!optionalAuthenticatedPrincipal.isPresent()) {
            this.logService.log(3, "Failed to authenticate username '" + username + "'.");
            this.requestForAuthentication(response);
            return;
        }
        String authenticatedPrincipal = (String)optionalAuthenticatedPrincipal.get();
        Optional optionalAuthenticatedResourceId = this.resourceIdResolver.getResourceId(authenticatedPrincipal);
        if (!optionalAuthenticatedResourceId.isPresent()) {
            this.logService.log(3, "Authenticated username '" + username + "' (aka mapped principal '" + authenticatedPrincipal + "') cannot be mapped to Resource ID");
            this.requestForAuthentication(response);
            return;
        }
        long authenticatedResourceId = (Long)optionalAuthenticatedResourceId.get();
        Exception exception = (Exception)this.authenticationPropagator.runAs(authenticatedResourceId, () -> {
            try {
                chain.doFilter(request, response);
                return null;
            }
            catch (Exception e) {
                this.logService.log(1, "Authenticated process execution failed", (Throwable)e);
                return e;
            }
        });
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void requestForAuthentication(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader(SERVER_HEADER_WWW_AUTHENTICATE, String.format(SERVER_HEADER_VALUE, this.realm));
    }
}

