/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.authentication.context.ri.internal;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.everit.osgi.authentication.context.AuthenticationContext;
import org.everit.osgi.authentication.context.AuthenticationPropagator;
import org.everit.osgi.props.PropertyManager;
import org.everit.osgi.resource.ResourceService;
import org.osgi.framework.BundleContext;

@Component(name="org.everit.osgi.authentication.context.ri.AuthenticationContext", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="resourceService.target"), @Property(name="propertyManager.target")})
@Service
public class AuthenticationContextComponent
implements AuthenticationContext,
AuthenticationPropagator {
    @Reference(bind="setResourceService")
    private ResourceService resourceService;
    @Reference(bind="setPropertyManager")
    private PropertyManager propertyManager;
    private final ThreadLocal<Long> currentResourceId = new ThreadLocal();
    private long defaultResourceId;

    @Activate
    public void activate(BundleContext context, Map<String, Object> componentProperties) {
        String defaultSubjectResourceIdProperty = this.propertyManager.getProperty("org.everit.osgi.authentication.context.ri.DEFAULT_RESOURCE_ID");
        if (defaultSubjectResourceIdProperty == null) {
            this.defaultResourceId = this.resourceService.createResource();
            this.propertyManager.addProperty("org.everit.osgi.authentication.context.ri.DEFAULT_RESOURCE_ID", String.valueOf(this.defaultResourceId));
        } else {
            this.defaultResourceId = Long.valueOf(defaultSubjectResourceIdProperty);
        }
    }

    public long getCurrentResourceId() {
        Long resourceId = this.currentResourceId.get();
        if (resourceId == null) {
            return this.defaultResourceId;
        }
        return resourceId;
    }

    public long getDefaultResourceId() {
        return this.defaultResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(long authenticatedResourceId, Supplier<T> authenticatedAction) {
        Objects.requireNonNull(authenticatedAction, "authenticatedAction cannot be null");
        Long localResourceId = this.currentResourceId.get();
        this.currentResourceId.set(authenticatedResourceId);
        T rval = null;
        try {
            rval = authenticatedAction.get();
        }
        finally {
            this.currentResourceId.set(localResourceId);
        }
        return rval;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void unbindPropertyManager(PropertyManager propertyManager) {
        if (this.propertyManager == propertyManager) {
            this.propertyManager = null;
        }
    }
}

