/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.JSONPointer;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

class ReferenceLookup {
    private LoadingState ls;

    static JSONObject extend(JSONObject additional, JSONObject original) {
        String[] additionalNames = JSONObject.getNames((JSONObject)additional);
        if (additionalNames == null) {
            return original;
        }
        String[] originalNames = JSONObject.getNames((JSONObject)original);
        if (originalNames == null) {
            return additional;
        }
        JSONObject rval = new JSONObject();
        Arrays.stream(originalNames).forEach(name -> rval.put(name, original.get(name)));
        Arrays.stream(additionalNames).forEach(name -> rval.put(name, additional.get(name)));
        return rval;
    }

    public ReferenceLookup(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot eb null");
    }

    static URI withoutFragment(String fullUri) {
        int hashmarkIdx = fullUri.indexOf(35);
        String rval = hashmarkIdx == -1 ? fullUri : fullUri.substring(0, hashmarkIdx);
        try {
            return new URI(rval);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    JSONObject withoutRef(JSONObject original) {
        String[] names = JSONObject.getNames((JSONObject)original);
        if (names == null) {
            return original;
        }
        JSONObject rval = new JSONObject();
        Arrays.stream(names).filter(name -> !"$ref".equals(name)).forEach(name -> rval.put(name, original.get(name)));
        return rval;
    }

    Schema.Builder<?> lookup(String relPointerString, JSONObject ctx) {
        String absPointerString = ReferenceResolver.resolve(this.ls.id, relPointerString).toString();
        if (this.ls.pointerSchemas.containsKey(absPointerString)) {
            return this.ls.pointerSchemas.get(absPointerString);
        }
        boolean isExternal = !absPointerString.startsWith("#");
        JSONPointer pointer = isExternal ? JSONPointer.forURL(this.ls.httpClient, absPointerString) : JSONPointer.forDocument(this.ls.rootSchemaJson, absPointerString);
        ReferenceSchema.Builder refBuilder = ReferenceSchema.builder().refValue(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, refBuilder);
        JSONPointer.QueryResult result = pointer.query();
        JSONObject resultObject = ReferenceLookup.extend(this.withoutRef(ctx), result.getQueryResult());
        SchemaLoader childLoader = this.ls.initChildLoader().resolutionScope(isExternal ? ReferenceLookup.withoutFragment(absPointerString) : this.ls.id).schemaJson(resultObject).rootSchemaJson(result.getContainingDocument()).build();
        Object referredSchema = childLoader.load().build();
        refBuilder.build().setReferredSchema((Schema)referredSchema);
        return refBuilder;
    }
}

