/*
 * Decompiled with CFR 0.152.
 */
package org.everit.cluster.invalidationmap.support.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.everit.cluster.invalidationmap.InvalidationMapConfiguration;
import org.everit.cluster.invalidationmap.MapInvalidator;
import org.everit.cluster.invalidationmap.support.node.NodeRegistry;
import org.everit.cluster.invalidationmap.support.remote.PingSender;

public class TaskScheduler
implements InvalidationMapConfiguration {
    private static final long DEFAULT_INVALIDATE_TIMEOUT = 30000L;
    private static final long DEFAULT_PING_PERIOD = 5000L;
    private static final Logger LOGGER = Logger.getLogger(TaskScheduler.class.getName());
    private static final int PING_SCHEDULER_CORE_POOL_SIZE = 3;
    private long invalidateAfterNodeCrashDelay = 30000L;
    private final ConcurrentMap<String, ScheduledFuture<?>> invalidateAfterNodeCrashSchedules = new ConcurrentHashMap();
    private final MapInvalidator invalidator;
    private long messageOrderCheckDelay = 5000L;
    private final ConcurrentMap<String, ScheduledFuture<?>> messageOrderCheckSchedules = new ConcurrentHashMap();
    private final NodeRegistry nodeRegistry;
    private long pingPeriod = 5000L;
    private final PingSender pingSender;
    private ScheduledFuture<?> pingSenderSchedule;
    private ScheduledExecutorService schedulerService;

    public TaskScheduler(NodeRegistry nodeRegistry, MapInvalidator invalidator, PingSender pingSender) {
        this.nodeRegistry = nodeRegistry;
        this.invalidator = invalidator;
        this.pingSender = pingSender;
        this.schedulerService = this.createSchedulerService();
    }

    public Runnable createInvalidateAfterNodeCrashTask(String nodeName) {
        return () -> {
            this.nodeRegistry.remove(nodeName);
            this.invalidator.invalidateAll();
            LOGGER.warning("Node " + nodeName + " was crashed. Local cache has been invalidated.");
        };
    }

    public Runnable createMessageOrderCheckTask(String nodeName, long lastPing) {
        return () -> {
            if (!this.nodeRegistry.checkMessageOrder(nodeName, lastPing)) {
                this.nodeRegistry.reset(nodeName, lastPing);
                this.invalidator.invalidateAll();
                LOGGER.warning("Incomming packet loss detected on node " + nodeName + ". Local cache has been invalidated.");
            }
        };
    }

    public Runnable createPingSenderTask() {
        return this.pingSender::ping;
    }

    private ScheduledExecutorService createSchedulerService() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3, threadFactory);
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return scheduler;
    }

    public synchronized long getInvalidateAfterNodeCrashDelay() {
        return this.invalidateAfterNodeCrashDelay;
    }

    public synchronized long getMessageOrderCheckDelay() {
        return this.messageOrderCheckDelay;
    }

    public synchronized long getPingPeriod() {
        return this.pingPeriod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void scheduleInvalidateOnNodeCrash(String nodeName, boolean reSchedule) {
        ScheduledFuture<?> invalidateOnNodeCrashFuture;
        if (this.schedulerService == null) {
            return;
        }
        ScheduledFuture prevScheduledFuture = (ScheduledFuture)this.invalidateAfterNodeCrashSchedules.get(nodeName);
        if (prevScheduledFuture == null || prevScheduledFuture.isDone()) {
            if (!reSchedule) return;
            invalidateOnNodeCrashFuture = this.schedulerService.schedule(this.createInvalidateAfterNodeCrashTask(nodeName), this.invalidateAfterNodeCrashDelay, TimeUnit.MILLISECONDS);
        } else if (reSchedule) {
            prevScheduledFuture.cancel(false);
            invalidateOnNodeCrashFuture = this.schedulerService.schedule(this.createInvalidateAfterNodeCrashTask(nodeName), this.invalidateAfterNodeCrashDelay, TimeUnit.MILLISECONDS);
        } else {
            prevScheduledFuture.cancel(false);
            return;
        }
        this.invalidateAfterNodeCrashSchedules.put(nodeName, invalidateOnNodeCrashFuture);
    }

    public synchronized void scheduleMessageOrderCheck(String nodeName, long lastPingMessageNumber) {
        if (this.schedulerService == null) {
            return;
        }
        ScheduledFuture prevScheduledFuture = (ScheduledFuture)this.messageOrderCheckSchedules.get(nodeName);
        if (prevScheduledFuture == null || prevScheduledFuture.isDone()) {
            LOGGER.info("Scheduling message order check on node " + nodeName);
            ScheduledFuture<?> messageOrderCheckFuture = this.schedulerService.schedule(this.createMessageOrderCheckTask(nodeName, lastPingMessageNumber), this.messageOrderCheckDelay, TimeUnit.MILLISECONDS);
            this.messageOrderCheckSchedules.put(nodeName, messageOrderCheckFuture);
        } else {
            LOGGER.info("Ping check already scheduled on node " + nodeName);
        }
    }

    public synchronized void schedulePingSender() {
        if (this.schedulerService == null) {
            return;
        }
        if (this.pingSenderSchedule != null && !this.pingSenderSchedule.isDone()) {
            this.pingSenderSchedule.cancel(true);
        }
        this.pingSenderSchedule = this.schedulerService.scheduleAtFixedRate(this.createPingSenderTask(), 0L, this.pingPeriod, TimeUnit.MILLISECONDS);
    }

    public synchronized void setInvalidateAfterNodeCrashDelay(long invalidateAfterNodeCrashDelay) {
        if (invalidateAfterNodeCrashDelay <= 0L) {
            throw new IllegalArgumentException("invalidateAfterNodeCrashDelay must be greater than zero");
        }
        if (invalidateAfterNodeCrashDelay <= this.pingPeriod) {
            throw new IllegalArgumentException("invalidateAfterNodeCrashDelay must be greater than pingPeriod");
        }
        this.invalidateAfterNodeCrashDelay = invalidateAfterNodeCrashDelay;
    }

    public synchronized void setMessageOrderCheckDelay(long messageOrderCheckDelay) {
        if (messageOrderCheckDelay <= 0L) {
            throw new IllegalArgumentException("messageOrderCheckDelay must be greater than zero");
        }
        this.messageOrderCheckDelay = messageOrderCheckDelay;
    }

    public synchronized void setPingPeriod(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be greater than zero");
        }
        if (this.pingPeriod >= this.invalidateAfterNodeCrashDelay) {
            throw new IllegalArgumentException("pingPeriod must be less than invalidateAfterNodeCrashDelay");
        }
        this.pingPeriod = period;
        this.schedulePingSender();
    }

    public void shutdown() {
        this.schedulerService.shutdownNow();
        this.schedulerService = null;
        this.pingSenderSchedule = null;
        this.messageOrderCheckSchedules.clear();
        this.invalidateAfterNodeCrashSchedules.clear();
    }
}

