/*
 * Decompiled with CFR 0.152.
 */
package org.everit.cluster.invalidationmap.support.node;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.everit.cluster.invalidationmap.support.node.NodeState;

public class NodeRegistry {
    private static final int MESSAGE_NUMBER_MAINTENANCE_THRESHOLD = 250;
    private final ConcurrentMap<String, NodeState> nodeState = new ConcurrentHashMap<String, NodeState>();

    public boolean checkMessageOrder(String nodeName, long messageNumber) {
        NodeState state = (NodeState)this.nodeState.get(nodeName);
        if (state == null) {
            return true;
        }
        long first = state.maintainGotMessageNumbers();
        return first >= messageNumber;
    }

    public synchronized void clear() {
        this.nodeState.clear();
    }

    public boolean ping(String nodeName, long messageNumber) {
        NodeState state = (NodeState)this.nodeState.get(nodeName);
        return state == null || state.gotMessageNumbers.last() >= messageNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(String nodeName, long messageNumber) {
        long last;
        NodeState state = (NodeState)this.nodeState.get(nodeName);
        if (state == null) {
            return true;
        }
        NodeState nodeState = state;
        synchronized (nodeState) {
            last = state.gotMessageNumbers.last();
            state.gotMessageNumbers.add(messageNumber);
        }
        if (state.gotMessageNumbers.size() > 250) {
            state.maintainGotMessageNumbers();
        }
        return last + 1L >= messageNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerIfNecessary(String nodeName, long startTimeNanos, long gotMessageNumber) {
        NodeState state = (NodeState)this.nodeState.get(nodeName);
        if (state != null && state.startTimeNanos == startTimeNanos) {
            return false;
        }
        NodeRegistry nodeRegistry = this;
        synchronized (nodeRegistry) {
            state = (NodeState)this.nodeState.get(nodeName);
            if (state != null && state.startTimeNanos == startTimeNanos) {
                return false;
            }
            state = new NodeState(startTimeNanos, gotMessageNumber);
            this.nodeState.put(nodeName, state);
            return true;
        }
    }

    public void remove(String nodeName) {
        this.nodeState.remove(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String nodeName, long messageNumber) {
        NodeState state = (NodeState)this.nodeState.get(nodeName);
        if (state == null) {
            return;
        }
        NodeState nodeState = state;
        synchronized (nodeState) {
            state.gotMessageNumbers.clear();
            state.gotMessageNumbers.add(messageNumber);
        }
    }
}

