/*
 * Decompiled with CFR 0.152.
 */
package org.everit.cache.noop.ecm.internal;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.everit.cache.CacheConstants;
import org.everit.cache.noop.NoOpConcurrentMap;
import org.everit.cache.noop.ecm.NoOpCacheConstants;
import org.everit.osgi.ecm.annotation.Activate;
import org.everit.osgi.ecm.annotation.Component;
import org.everit.osgi.ecm.annotation.ConfigurationPolicy;
import org.everit.osgi.ecm.annotation.Deactivate;
import org.everit.osgi.ecm.annotation.ManualService;
import org.everit.osgi.ecm.annotation.ManualServices;
import org.everit.osgi.ecm.annotation.attribute.StringAttribute;
import org.everit.osgi.ecm.annotation.attribute.StringAttributes;
import org.everit.osgi.ecm.component.ComponentContext;
import org.everit.osgi.ecm.extender.ExtendComponent;
import org.osgi.framework.ServiceRegistration;

@Component(componentId="org.everit.cache.noop.ecm.NoOpCacheComponent", configurationPolicy=ConfigurationPolicy.IGNORE, label="Everit NoOp Cache", description="A simple Map registered as an OSGi service that does nothing.")
@StringAttributes(value={@StringAttribute(attributeId="service.description", defaultValue={"No-operation cache"}, priority=1.0f, label="Service Description", description="The description of this component configuration. It is used to easily identify the service registered by this component."), @StringAttribute(attributeId="cache.driver.name", defaultValue={"noop"}, priority=2.0f, label="Cache driver name", description="The name of the cache driver.")})
@ManualServices(value={@ManualService(value={Map.class, ConcurrentMap.class})})
@ExtendComponent
public class NoOpCacheComponent<K, V> {
    public static final int P1_SERVICE_DESCRIPTION = 1;
    public static final int P2_CACHE_DRIVER_NAME = 2;
    private ServiceRegistration<?> cacheSR;

    @Activate
    public void activate(ComponentContext<NoOpCacheComponent<?, ?>> componentContext) {
        Hashtable serviceProperties = new Hashtable(componentContext.getProperties());
        this.cacheSR = componentContext.registerService(new String[]{NoOpCacheConstants.OBJECT_CLASS_CONCURRENT_MAP.getName(), CacheConstants.OBJECT_CLASS_MAP.getName()}, (Object)new NoOpConcurrentMap(), serviceProperties);
    }

    @Deactivate
    public void deactivate() throws Exception {
        if (this.cacheSR != null) {
            this.cacheSR.unregister();
        }
    }
}

