/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowElementReference;

@ApiModel(description="The details about a workflow validation error.")
public class WorkflowValidationError {
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="elementReference")
    private WorkflowElementReference elementReference;
    @JsonProperty(value="level")
    private LevelEnum level;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="type")
    private TypeEnum type;

    public WorkflowValidationError code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="An error code.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public WorkflowValidationError elementReference(WorkflowElementReference elementReference) {
        this.elementReference = elementReference;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowElementReference getElementReference() {
        return this.elementReference;
    }

    public void setElementReference(WorkflowElementReference elementReference) {
        this.elementReference = elementReference;
    }

    public WorkflowValidationError level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(value="The validation error level.")
    public LevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public WorkflowValidationError message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="An error message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public WorkflowValidationError type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of element the error or warning references.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowValidationError workflowValidationError = (WorkflowValidationError)o;
        return Objects.equals(this.code, workflowValidationError.code) && Objects.equals(this.elementReference, workflowValidationError.elementReference) && Objects.equals((Object)this.level, (Object)workflowValidationError.level) && Objects.equals(this.message, workflowValidationError.message) && Objects.equals((Object)this.type, (Object)workflowValidationError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.elementReference, this.level, this.message, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowValidationError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    elementReference: ").append(this.toIndentedString(this.elementReference)).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        RULE("RULE"),
        STATUS("STATUS"),
        STATUS_LAYOUT("STATUS_LAYOUT"),
        STATUS_PROPERTY("STATUS_PROPERTY"),
        WORKFLOW("WORKFLOW"),
        TRANSITION("TRANSITION"),
        TRANSITION_PROPERTY("TRANSITION_PROPERTY"),
        SCOPE("SCOPE"),
        STATUS_MAPPING("STATUS_MAPPING"),
        TRIGGER("TRIGGER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LevelEnum {
        WARNING("WARNING"),
        ERROR("ERROR");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LevelEnum fromValue(String value) {
            for (LevelEnum b : LevelEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

