/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Details of a workflow status.")
public class WorkflowStatus {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();

    public WorkflowStatus id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the issue status.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the status in the workflow.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowStatus properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public WorkflowStatus putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Additional properties that modify the behavior of issues in this status. Supports the properties `jira.issue.editable` and `issueEditable` (deprecated) that indicate whether issues are editable.")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowStatus workflowStatus = (WorkflowStatus)o;
        return Objects.equals(this.id, workflowStatus.id) && Objects.equals(this.name, workflowStatus.name) && Objects.equals(this.properties, workflowStatus.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

