/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowSchemeAssociation;

@ApiModel(description="The request payload to get the required mappings for updating a workflow scheme.")
public class WorkflowSchemeUpdateRequiredMappingsRequest {
    @JsonProperty(value="defaultWorkflowId")
    private String defaultWorkflowId;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="workflowsForIssueTypes")
    private List<WorkflowSchemeAssociation> workflowsForIssueTypes = new ArrayList<WorkflowSchemeAssociation>();

    public WorkflowSchemeUpdateRequiredMappingsRequest defaultWorkflowId(String defaultWorkflowId) {
        this.defaultWorkflowId = defaultWorkflowId;
        return this;
    }

    @ApiModelProperty(value="The ID of the new default workflow for this workflow scheme. Only used in global-scoped workflow schemes. If it isn't specified, is set to *Jira Workflow (jira)*.")
    public String getDefaultWorkflowId() {
        return this.defaultWorkflowId;
    }

    public void setDefaultWorkflowId(String defaultWorkflowId) {
        this.defaultWorkflowId = defaultWorkflowId;
    }

    public WorkflowSchemeUpdateRequiredMappingsRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the workflow scheme.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowSchemeUpdateRequiredMappingsRequest workflowsForIssueTypes(List<WorkflowSchemeAssociation> workflowsForIssueTypes) {
        this.workflowsForIssueTypes = workflowsForIssueTypes;
        return this;
    }

    public WorkflowSchemeUpdateRequiredMappingsRequest addWorkflowsForIssueTypesItem(WorkflowSchemeAssociation workflowsForIssueTypesItem) {
        this.workflowsForIssueTypes.add(workflowsForIssueTypesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The new workflow to issue type mappings for this workflow scheme.")
    public List<WorkflowSchemeAssociation> getWorkflowsForIssueTypes() {
        return this.workflowsForIssueTypes;
    }

    public void setWorkflowsForIssueTypes(List<WorkflowSchemeAssociation> workflowsForIssueTypes) {
        this.workflowsForIssueTypes = workflowsForIssueTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSchemeUpdateRequiredMappingsRequest workflowSchemeUpdateRequiredMappingsRequest = (WorkflowSchemeUpdateRequiredMappingsRequest)o;
        return Objects.equals(this.defaultWorkflowId, workflowSchemeUpdateRequiredMappingsRequest.defaultWorkflowId) && Objects.equals(this.id, workflowSchemeUpdateRequiredMappingsRequest.id) && Objects.equals(this.workflowsForIssueTypes, workflowSchemeUpdateRequiredMappingsRequest.workflowsForIssueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.defaultWorkflowId, this.id, this.workflowsForIssueTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowSchemeUpdateRequiredMappingsRequest {\n");
        sb.append("    defaultWorkflowId: ").append(this.toIndentedString(this.defaultWorkflowId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    workflowsForIssueTypes: ").append(this.toIndentedString(this.workflowsForIssueTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

