/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.DocumentVersion;
import org.everit.atlassian.restclient.jiracloud.v3.model.MappingsByIssueTypeOverride;
import org.everit.atlassian.restclient.jiracloud.v3.model.MappingsByWorkflow;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowSchemeAssociation;

@ApiModel(description="The update workflow scheme payload.")
public class WorkflowSchemeUpdateRequest {
    @JsonProperty(value="defaultWorkflowId")
    private String defaultWorkflowId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="statusMappingsByIssueTypeOverride")
    private List<MappingsByIssueTypeOverride> statusMappingsByIssueTypeOverride = new ArrayList<MappingsByIssueTypeOverride>();
    @JsonProperty(value="statusMappingsByWorkflows")
    private List<MappingsByWorkflow> statusMappingsByWorkflows = new ArrayList<MappingsByWorkflow>();
    @JsonProperty(value="version")
    private DocumentVersion version;
    @JsonProperty(value="workflowsForIssueTypes")
    private List<WorkflowSchemeAssociation> workflowsForIssueTypes = new ArrayList<WorkflowSchemeAssociation>();
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public WorkflowSchemeUpdateRequest defaultWorkflowId(String defaultWorkflowId) {
        this.defaultWorkflowId = defaultWorkflowId;
        return this;
    }

    @ApiModelProperty(value="The ID of the workflow for issue types without having a mapping defined in this workflow scheme. Only used in global-scoped workflow schemes. If the `defaultWorkflowId` isn't specified, this is set to *Jira Workflow (jira)*.")
    public String getDefaultWorkflowId() {
        return this.defaultWorkflowId;
    }

    public void setDefaultWorkflowId(String defaultWorkflowId) {
        this.defaultWorkflowId = defaultWorkflowId;
    }

    public WorkflowSchemeUpdateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The new description for this workflow scheme.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowSchemeUpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of this workflow scheme.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowSchemeUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The new name for this workflow scheme.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowSchemeUpdateRequest statusMappingsByIssueTypeOverride(List<MappingsByIssueTypeOverride> statusMappingsByIssueTypeOverride) {
        this.statusMappingsByIssueTypeOverride = statusMappingsByIssueTypeOverride;
        return this;
    }

    public WorkflowSchemeUpdateRequest addStatusMappingsByIssueTypeOverrideItem(MappingsByIssueTypeOverride statusMappingsByIssueTypeOverrideItem) {
        if (this.statusMappingsByIssueTypeOverride == null) {
            this.statusMappingsByIssueTypeOverride = new ArrayList<MappingsByIssueTypeOverride>();
        }
        this.statusMappingsByIssueTypeOverride.add(statusMappingsByIssueTypeOverrideItem);
        return this;
    }

    @ApiModelProperty(value="Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.")
    public List<MappingsByIssueTypeOverride> getStatusMappingsByIssueTypeOverride() {
        return this.statusMappingsByIssueTypeOverride;
    }

    public void setStatusMappingsByIssueTypeOverride(List<MappingsByIssueTypeOverride> statusMappingsByIssueTypeOverride) {
        this.statusMappingsByIssueTypeOverride = statusMappingsByIssueTypeOverride;
    }

    public WorkflowSchemeUpdateRequest statusMappingsByWorkflows(List<MappingsByWorkflow> statusMappingsByWorkflows) {
        this.statusMappingsByWorkflows = statusMappingsByWorkflows;
        return this;
    }

    public WorkflowSchemeUpdateRequest addStatusMappingsByWorkflowsItem(MappingsByWorkflow statusMappingsByWorkflowsItem) {
        if (this.statusMappingsByWorkflows == null) {
            this.statusMappingsByWorkflows = new ArrayList<MappingsByWorkflow>();
        }
        this.statusMappingsByWorkflows.add(statusMappingsByWorkflowsItem);
        return this;
    }

    @ApiModelProperty(value="The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.")
    public List<MappingsByWorkflow> getStatusMappingsByWorkflows() {
        return this.statusMappingsByWorkflows;
    }

    public void setStatusMappingsByWorkflows(List<MappingsByWorkflow> statusMappingsByWorkflows) {
        this.statusMappingsByWorkflows = statusMappingsByWorkflows;
    }

    public WorkflowSchemeUpdateRequest version(DocumentVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentVersion getVersion() {
        return this.version;
    }

    public void setVersion(DocumentVersion version) {
        this.version = version;
    }

    public WorkflowSchemeUpdateRequest workflowsForIssueTypes(List<WorkflowSchemeAssociation> workflowsForIssueTypes) {
        this.workflowsForIssueTypes = workflowsForIssueTypes;
        return this;
    }

    public WorkflowSchemeUpdateRequest addWorkflowsForIssueTypesItem(WorkflowSchemeAssociation workflowsForIssueTypesItem) {
        if (this.workflowsForIssueTypes == null) {
            this.workflowsForIssueTypes = new ArrayList<WorkflowSchemeAssociation>();
        }
        this.workflowsForIssueTypes.add(workflowsForIssueTypesItem);
        return this;
    }

    @ApiModelProperty(value="Mappings from workflows to issue types.")
    public List<WorkflowSchemeAssociation> getWorkflowsForIssueTypes() {
        return this.workflowsForIssueTypes;
    }

    public void setWorkflowsForIssueTypes(List<WorkflowSchemeAssociation> workflowsForIssueTypes) {
        this.workflowsForIssueTypes = workflowsForIssueTypes;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSchemeUpdateRequest workflowSchemeUpdateRequest = (WorkflowSchemeUpdateRequest)o;
        return Objects.equals(this.defaultWorkflowId, workflowSchemeUpdateRequest.defaultWorkflowId) && Objects.equals(this.description, workflowSchemeUpdateRequest.description) && Objects.equals(this.id, workflowSchemeUpdateRequest.id) && Objects.equals(this.name, workflowSchemeUpdateRequest.name) && Objects.equals(this.statusMappingsByIssueTypeOverride, workflowSchemeUpdateRequest.statusMappingsByIssueTypeOverride) && Objects.equals(this.statusMappingsByWorkflows, workflowSchemeUpdateRequest.statusMappingsByWorkflows) && Objects.equals(this.version, workflowSchemeUpdateRequest.version) && Objects.equals(this.workflowsForIssueTypes, workflowSchemeUpdateRequest.workflowsForIssueTypes) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.defaultWorkflowId, this.description, this.id, this.name, this.statusMappingsByIssueTypeOverride, this.statusMappingsByWorkflows, this.version, this.workflowsForIssueTypes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowSchemeUpdateRequest {\n");
        sb.append("    defaultWorkflowId: ").append(this.toIndentedString(this.defaultWorkflowId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statusMappingsByIssueTypeOverride: ").append(this.toIndentedString(this.statusMappingsByIssueTypeOverride)).append("\n");
        sb.append("    statusMappingsByWorkflows: ").append(this.toIndentedString(this.statusMappingsByWorkflows)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    workflowsForIssueTypes: ").append(this.toIndentedString(this.workflowsForIssueTypes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

