/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The explicit association between issue types and a workflow in a workflow scheme.")
public class WorkflowSchemeAssociation {
    @JsonProperty(value="issueTypeIds")
    private List<String> issueTypeIds = new ArrayList<String>();
    @JsonProperty(value="workflowId")
    private String workflowId;

    public WorkflowSchemeAssociation issueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public WorkflowSchemeAssociation addIssueTypeIdsItem(String issueTypeIdsItem) {
        this.issueTypeIds.add(issueTypeIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The issue types assigned to the workflow.")
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public void setIssueTypeIds(List<String> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
    }

    public WorkflowSchemeAssociation workflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the workflow.")
    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowSchemeAssociation workflowSchemeAssociation = (WorkflowSchemeAssociation)o;
        return Objects.equals(this.issueTypeIds, workflowSchemeAssociation.issueTypeIds) && Objects.equals(this.workflowId, workflowSchemeAssociation.workflowId);
    }

    public int hashCode() {
        return Objects.hash(this.issueTypeIds, this.workflowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowSchemeAssociation {\n");
        sb.append("    issueTypeIds: ").append(this.toIndentedString(this.issueTypeIds)).append("\n");
        sb.append("    workflowId: ").append(this.toIndentedString(this.workflowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

