/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowStatusLayout;

@ApiModel(description="The statuses referenced in the workflow.")
public class WorkflowReferenceStatus {
    @JsonProperty(value="deprecated")
    private Boolean deprecated;
    @JsonProperty(value="layout")
    private WorkflowStatusLayout layout;
    @JsonProperty(value="properties")
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty(value="statusReference")
    private String statusReference;

    public WorkflowReferenceStatus deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @ApiModelProperty(value="Indicates if the status is deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public WorkflowReferenceStatus layout(WorkflowStatusLayout layout) {
        this.layout = layout;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowStatusLayout getLayout() {
        return this.layout;
    }

    public void setLayout(WorkflowStatusLayout layout) {
        this.layout = layout;
    }

    public WorkflowReferenceStatus properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public WorkflowReferenceStatus putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="The properties associated with the status.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public WorkflowReferenceStatus statusReference(String statusReference) {
        this.statusReference = statusReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the status.")
    public String getStatusReference() {
        return this.statusReference;
    }

    public void setStatusReference(String statusReference) {
        this.statusReference = statusReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowReferenceStatus workflowReferenceStatus = (WorkflowReferenceStatus)o;
        return Objects.equals(this.deprecated, workflowReferenceStatus.deprecated) && Objects.equals(this.layout, workflowReferenceStatus.layout) && Objects.equals(this.properties, workflowReferenceStatus.properties) && Objects.equals(this.statusReference, workflowReferenceStatus.statusReference);
    }

    public int hashCode() {
        return Objects.hash(this.deprecated, this.layout, this.properties, this.statusReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowReferenceStatus {\n");
        sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n");
        sb.append("    layout: ").append(this.toIndentedString(this.layout)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    statusReference: ").append(this.toIndentedString(this.statusReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

