/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowCreate;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowScope;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowStatusUpdate;

@ApiModel(description="The create workflows payload.")
public class WorkflowCreateRequest {
    @JsonProperty(value="scope")
    private WorkflowScope scope;
    @JsonProperty(value="statuses")
    private List<WorkflowStatusUpdate> statuses = new ArrayList<WorkflowStatusUpdate>();
    @JsonProperty(value="workflows")
    private List<WorkflowCreate> workflows = new ArrayList<WorkflowCreate>();

    public WorkflowCreateRequest scope(WorkflowScope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WorkflowScope getScope() {
        return this.scope;
    }

    public void setScope(WorkflowScope scope) {
        this.scope = scope;
    }

    public WorkflowCreateRequest statuses(List<WorkflowStatusUpdate> statuses) {
        this.statuses = statuses;
        return this;
    }

    public WorkflowCreateRequest addStatusesItem(WorkflowStatusUpdate statusesItem) {
        this.statuses.add(statusesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The statuses to associate with the workflows.")
    public List<WorkflowStatusUpdate> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<WorkflowStatusUpdate> statuses) {
        this.statuses = statuses;
    }

    public WorkflowCreateRequest workflows(List<WorkflowCreate> workflows) {
        this.workflows = workflows;
        return this;
    }

    public WorkflowCreateRequest addWorkflowsItem(WorkflowCreate workflowsItem) {
        this.workflows.add(workflowsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The details of the workflows to create.")
    public List<WorkflowCreate> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(List<WorkflowCreate> workflows) {
        this.workflows = workflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowCreateRequest workflowCreateRequest = (WorkflowCreateRequest)o;
        return Objects.equals(this.scope, workflowCreateRequest.scope) && Objects.equals(this.statuses, workflowCreateRequest.statuses) && Objects.equals(this.workflows, workflowCreateRequest.workflows);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.statuses, this.workflows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowCreateRequest {\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    statuses: ").append(this.toIndentedString(this.statuses)).append("\n");
        sb.append("    workflows: ").append(this.toIndentedString(this.workflows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

