/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A compound workflow transition rule condition. This object returns `nodeType` as `compound`.")
public class WorkflowCompoundCondition {
    @JsonProperty(value="conditions")
    private List<Object> conditions = new ArrayList<Object>();
    @JsonProperty(value="nodeType")
    private String nodeType;
    @JsonProperty(value="operator")
    private OperatorEnum operator;

    public WorkflowCompoundCondition conditions(List<Object> conditions) {
        this.conditions = conditions;
        return this;
    }

    public WorkflowCompoundCondition addConditionsItem(Object conditionsItem) {
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of workflow conditions.")
    public List<Object> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Object> conditions) {
        this.conditions = conditions;
    }

    public WorkflowCompoundCondition nodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public WorkflowCompoundCondition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The compound condition operator.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowCompoundCondition workflowCompoundCondition = (WorkflowCompoundCondition)o;
        return Objects.equals(this.conditions, workflowCompoundCondition.conditions) && Objects.equals(this.nodeType, workflowCompoundCondition.nodeType) && Objects.equals((Object)this.operator, (Object)workflowCompoundCondition.operator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.nodeType, this.operator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowCompoundCondition {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    nodeType: ").append(this.toIndentedString(this.nodeType)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        AND("AND"),
        OR("OR");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

