/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.User;

@ApiModel(description="The details of votes on an issue.")
public class Votes {
    @JsonProperty(value="hasVoted")
    private Boolean hasVoted;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="voters")
    private List<User> voters = new ArrayList<User>();
    @JsonProperty(value="votes")
    private Long votes;

    @ApiModelProperty(value="Whether the user making this request has voted on the issue.")
    public Boolean getHasVoted() {
        return this.hasVoted;
    }

    @ApiModelProperty(value="The URL of these issue vote details.")
    public URI getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="List of the users who have voted on this issue. An empty list is returned when the calling user doesn't have the *View voters and watchers* project permission.")
    public List<User> getVoters() {
        return this.voters;
    }

    @ApiModelProperty(value="The number of votes on the issue.")
    public Long getVotes() {
        return this.votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Votes votes = (Votes)o;
        return Objects.equals(this.hasVoted, votes.hasVoted) && Objects.equals(this.self, votes.self) && Objects.equals(this.voters, votes.voters) && Objects.equals(this.votes, votes.votes);
    }

    public int hashCode() {
        return Objects.hash(this.hasVoted, this.self, this.voters, this.votes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Votes {\n");
        sb.append("    hasVoted: ").append(this.toIndentedString(this.hasVoted)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    voters: ").append(this.toIndentedString(this.voters)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

