/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The group or role to which this item is visible.")
public class Visibility {
    @JsonProperty(value="identifier")
    private String identifier;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="value")
    private String value;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public Visibility identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(value="The ID of the group or the name of the role that visibility of this item is restricted to.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Visibility type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Whether visibility of this item is restricted to a group or role.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Visibility value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The name of the group or role that visibility of this item is restricted to. Please note that the name of a group is mutable, to reliably identify a group use `identifier`.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Visibility visibility = (Visibility)o;
        return Objects.equals(this.identifier, visibility.identifier) && Objects.equals((Object)this.type, (Object)visibility.type) && Objects.equals(this.value, visibility.value) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type, this.value, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Visibility {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GROUP("group"),
        ROLE("role");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

