/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="List of user account IDs.")
public class UserKey {
    @JsonProperty(value="accountId")
    private String accountId;
    @JsonProperty(value="key")
    private String key;

    public UserKey accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Returns *unknown* if the record is deleted and corrupted, for example, as the result of a server import.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public UserKey key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserKey userKey = (UserKey)o;
        return Objects.equals(this.accountId, userKey.accountId) && Objects.equals(this.key, userKey.key);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserKey {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

