/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Filter for a User Picker (single) custom field.")
public class UserFilter {
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="groups")
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="roleIds")
    private List<Long> roleIds = new ArrayList<Long>();

    public UserFilter enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the filter is enabled.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UserFilter groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public UserFilter addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="User groups autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 groups can be provided.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public UserFilter roleIds(List<Long> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public UserFilter addRoleIdsItem(Long roleIdsItem) {
        if (this.roleIds == null) {
            this.roleIds = new ArrayList<Long>();
        }
        this.roleIds.add(roleIdsItem);
        return this;
    }

    @ApiModelProperty(value="Roles that autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 roles can be provided.")
    public List<Long> getRoleIds() {
        return this.roleIds;
    }

    public void setRoleIds(List<Long> roleIds) {
        this.roleIds = roleIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFilter userFilter = (UserFilter)o;
        return Objects.equals(this.enabled, userFilter.enabled) && Objects.equals(this.groups, userFilter.groups) && Objects.equals(this.roleIds, userFilter.roleIds);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.groups, this.roleIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFilter {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    roleIds: ").append(this.toIndentedString(this.roleIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

