/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of the time tracking configuration.")
public class TimeTrackingConfiguration {
    @JsonProperty(value="defaultUnit")
    private DefaultUnitEnum defaultUnit;
    @JsonProperty(value="timeFormat")
    private TimeFormatEnum timeFormat;
    @JsonProperty(value="workingDaysPerWeek")
    private Double workingDaysPerWeek;
    @JsonProperty(value="workingHoursPerDay")
    private Double workingHoursPerDay;

    public TimeTrackingConfiguration defaultUnit(DefaultUnitEnum defaultUnit) {
        this.defaultUnit = defaultUnit;
        return this;
    }

    @ApiModelProperty(required=true, value="The default unit of time applied to logged time.")
    public DefaultUnitEnum getDefaultUnit() {
        return this.defaultUnit;
    }

    public void setDefaultUnit(DefaultUnitEnum defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public TimeTrackingConfiguration timeFormat(TimeFormatEnum timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="The format that will appear on an issue's *Time Spent* field.")
    public TimeFormatEnum getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(TimeFormatEnum timeFormat) {
        this.timeFormat = timeFormat;
    }

    public TimeTrackingConfiguration workingDaysPerWeek(Double workingDaysPerWeek) {
        this.workingDaysPerWeek = workingDaysPerWeek;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of days in a working week.")
    public Double getWorkingDaysPerWeek() {
        return this.workingDaysPerWeek;
    }

    public void setWorkingDaysPerWeek(Double workingDaysPerWeek) {
        this.workingDaysPerWeek = workingDaysPerWeek;
    }

    public TimeTrackingConfiguration workingHoursPerDay(Double workingHoursPerDay) {
        this.workingHoursPerDay = workingHoursPerDay;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of hours in a working day.")
    public Double getWorkingHoursPerDay() {
        return this.workingHoursPerDay;
    }

    public void setWorkingHoursPerDay(Double workingHoursPerDay) {
        this.workingHoursPerDay = workingHoursPerDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeTrackingConfiguration timeTrackingConfiguration = (TimeTrackingConfiguration)o;
        return Objects.equals((Object)this.defaultUnit, (Object)timeTrackingConfiguration.defaultUnit) && Objects.equals((Object)this.timeFormat, (Object)timeTrackingConfiguration.timeFormat) && Objects.equals(this.workingDaysPerWeek, timeTrackingConfiguration.workingDaysPerWeek) && Objects.equals(this.workingHoursPerDay, timeTrackingConfiguration.workingHoursPerDay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultUnit, this.timeFormat, this.workingDaysPerWeek, this.workingHoursPerDay});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeTrackingConfiguration {\n");
        sb.append("    defaultUnit: ").append(this.toIndentedString((Object)this.defaultUnit)).append("\n");
        sb.append("    timeFormat: ").append(this.toIndentedString((Object)this.timeFormat)).append("\n");
        sb.append("    workingDaysPerWeek: ").append(this.toIndentedString(this.workingDaysPerWeek)).append("\n");
        sb.append("    workingHoursPerDay: ").append(this.toIndentedString(this.workingHoursPerDay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TimeFormatEnum {
        PRETTY("pretty"),
        DAYS("days"),
        HOURS("hours");

        private String value;

        private TimeFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TimeFormatEnum fromValue(String value) {
            for (TimeFormatEnum b : TimeFormatEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DefaultUnitEnum {
        MINUTE("minute"),
        HOUR("hour"),
        DAY("day"),
        WEEK("week");

        private String value;

        private DefaultUnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DefaultUnitEnum fromValue(String value) {
            for (DefaultUnitEnum b : DefaultUnitEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

