/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.SecurityLevel;

@ApiModel(description="Details about a security scheme.")
public class SecurityScheme {
    @JsonProperty(value="defaultSecurityLevelId")
    private Long defaultSecurityLevelId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="levels")
    private List<SecurityLevel> levels = new ArrayList<SecurityLevel>();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="self")
    private String self;

    @ApiModelProperty(value="The ID of the default security level.")
    public Long getDefaultSecurityLevelId() {
        return this.defaultSecurityLevelId;
    }

    @ApiModelProperty(value="The description of the issue security scheme.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The ID of the issue security scheme.")
    public Long getId() {
        return this.id;
    }

    public SecurityScheme levels(List<SecurityLevel> levels) {
        this.levels = levels;
        return this;
    }

    public SecurityScheme addLevelsItem(SecurityLevel levelsItem) {
        if (this.levels == null) {
            this.levels = new ArrayList<SecurityLevel>();
        }
        this.levels.add(levelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SecurityLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(List<SecurityLevel> levels) {
        this.levels = levels;
    }

    @ApiModelProperty(value="The name of the issue security scheme.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The URL of the issue security scheme.")
    public String getSelf() {
        return this.self;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityScheme securityScheme = (SecurityScheme)o;
        return Objects.equals(this.defaultSecurityLevelId, securityScheme.defaultSecurityLevelId) && Objects.equals(this.description, securityScheme.description) && Objects.equals(this.id, securityScheme.id) && Objects.equals(this.levels, securityScheme.levels) && Objects.equals(this.name, securityScheme.name) && Objects.equals(this.self, securityScheme.self);
    }

    public int hashCode() {
        return Objects.hash(this.defaultSecurityLevelId, this.description, this.id, this.levels, this.name, this.self);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityScheme {\n");
        sb.append("    defaultSecurityLevelId: ").append(this.toIndentedString(this.defaultSecurityLevelId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    levels: ").append(this.toIndentedString(this.levels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

