/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.IssueBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.JsonTypeBean;

@ApiModel(description="The result of a JQL search.")
public class SearchResults {
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="issues")
    private List<IssueBean> issues = new ArrayList<IssueBean>();
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="names")
    private Map<String, String> names = new HashMap<String, String>();
    @JsonProperty(value="schema")
    private Map<String, JsonTypeBean> schema = new HashMap<String, JsonTypeBean>();
    @JsonProperty(value="startAt")
    private Integer startAt;
    @JsonProperty(value="total")
    private Integer total;
    @JsonProperty(value="warningMessages")
    private List<String> warningMessages = new ArrayList<String>();

    @ApiModelProperty(value="Expand options that include additional search result details in the response.")
    public String getExpand() {
        return this.expand;
    }

    @ApiModelProperty(value="The list of issues found by the search.")
    public List<IssueBean> getIssues() {
        return this.issues;
    }

    @ApiModelProperty(value="The maximum number of results that could be on the page.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @ApiModelProperty(value="The ID and name of each field in the search results.")
    public Map<String, String> getNames() {
        return this.names;
    }

    @ApiModelProperty(value="The schema describing the field types in the search results.")
    public Map<String, JsonTypeBean> getSchema() {
        return this.schema;
    }

    @ApiModelProperty(value="The index of the first item returned on the page.")
    public Integer getStartAt() {
        return this.startAt;
    }

    @ApiModelProperty(value="The number of results on the page.")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="Any warnings related to the JQL query.")
    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResults searchResults = (SearchResults)o;
        return Objects.equals(this.expand, searchResults.expand) && Objects.equals(this.issues, searchResults.issues) && Objects.equals(this.maxResults, searchResults.maxResults) && Objects.equals(this.names, searchResults.names) && Objects.equals(this.schema, searchResults.schema) && Objects.equals(this.startAt, searchResults.startAt) && Objects.equals(this.total, searchResults.total) && Objects.equals(this.warningMessages, searchResults.warningMessages);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.issues, this.maxResults, this.names, this.schema, this.startAt, this.total, this.warningMessages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResults {\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    warningMessages: ").append(this.toIndentedString(this.warningMessages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

