/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectRoleGroup;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectRoleUser;

@ApiModel(description="Details about a user assigned to a project role.")
public class RoleActor {
    @JsonProperty(value="actorGroup")
    private ProjectRoleGroup actorGroup;
    @JsonProperty(value="actorUser")
    private ProjectRoleUser actorUser;
    @JsonProperty(value="avatarUrl")
    private URI avatarUrl;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private TypeEnum type;

    @ApiModelProperty(value="")
    public ProjectRoleGroup getActorGroup() {
        return this.actorGroup;
    }

    @ApiModelProperty(value="")
    public ProjectRoleUser getActorUser() {
        return this.actorUser;
    }

    @ApiModelProperty(value="The avatar of the role actor.")
    public URI getAvatarUrl() {
        return this.avatarUrl;
    }

    @ApiModelProperty(value="The display name of the role actor. For users, depending on the user\u2019s privacy setting, this may return an alternative value for the user's name.")
    public String getDisplayName() {
        return this.displayName;
    }

    @ApiModelProperty(value="The ID of the role actor.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The type of role actor.")
    public TypeEnum getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleActor roleActor = (RoleActor)o;
        return Objects.equals(this.actorGroup, roleActor.actorGroup) && Objects.equals(this.actorUser, roleActor.actorUser) && Objects.equals(this.avatarUrl, roleActor.avatarUrl) && Objects.equals(this.displayName, roleActor.displayName) && Objects.equals(this.id, roleActor.id) && Objects.equals(this.name, roleActor.name) && Objects.equals((Object)this.type, (Object)roleActor.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actorGroup, this.actorUser, this.avatarUrl, this.displayName, this.id, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleActor {\n");
        sb.append("    actorGroup: ").append(this.toIndentedString(this.actorGroup)).append("\n");
        sb.append("    actorUser: ").append(this.toIndentedString(this.actorUser)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GROUP_ROLE_ACTOR("atlassian-group-role-actor"),
        USER_ROLE_ACTOR("atlassian-user-role-actor");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

