/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.Application;
import org.everit.atlassian.restclient.jiracloud.v3.model.RemoteObject;

@ApiModel(description="Details of a remote issue link.")
public class RemoteIssueLinkRequest {
    @JsonProperty(value="application")
    private Application application;
    @JsonProperty(value="globalId")
    private String globalId;
    @JsonProperty(value="object")
    private RemoteObject _object;
    @JsonProperty(value="relationship")
    private String relationship;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public RemoteIssueLinkRequest application(Application application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(value="Details of the remote application the linked item is in. For example, trello.")
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public RemoteIssueLinkRequest globalId(String globalId) {
        this.globalId = globalId;
        return this;
    }

    @ApiModelProperty(value="An identifier for the remote item in the remote system. For example, the global ID for a remote item in Confluence would consist of the app ID and page ID, like this: `appId=456&pageId=123`.  Setting this field enables the remote issue link details to be updated or deleted using remote system and item details as the record identifier, rather than using the record's Jira ID.  The maximum length is 255 characters.")
    public String getGlobalId() {
        return this.globalId;
    }

    public void setGlobalId(String globalId) {
        this.globalId = globalId;
    }

    public RemoteIssueLinkRequest _object(RemoteObject _object) {
        this._object = _object;
        return this;
    }

    @ApiModelProperty(required=true, value="Details of the item linked to.")
    public RemoteObject getObject() {
        return this._object;
    }

    public void setObject(RemoteObject _object) {
        this._object = _object;
    }

    public RemoteIssueLinkRequest relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @ApiModelProperty(value="Description of the relationship between the issue and the linked item. If not set, the relationship description \"links to\" is used in Jira.")
    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteIssueLinkRequest remoteIssueLinkRequest = (RemoteIssueLinkRequest)o;
        return Objects.equals(this.application, remoteIssueLinkRequest.application) && Objects.equals(this.globalId, remoteIssueLinkRequest.globalId) && Objects.equals(this._object, remoteIssueLinkRequest._object) && Objects.equals(this.relationship, remoteIssueLinkRequest.relationship) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.globalId, this._object, this.relationship, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemoteIssueLinkRequest {\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    globalId: ").append(this.toIndentedString(this.globalId)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString(this.relationship)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

