/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.Application;
import org.everit.atlassian.restclient.jiracloud.v3.model.RemoteObject;

@ApiModel(description="Details of an issue remote link.")
public class RemoteIssueLink {
    @JsonProperty(value="application")
    private Application application;
    @JsonProperty(value="globalId")
    private String globalId;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="object")
    private RemoteObject _object;
    @JsonProperty(value="relationship")
    private String relationship;
    @JsonProperty(value="self")
    private URI self;

    public RemoteIssueLink application(Application application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(value="Details of the remote application the linked item is in.")
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public RemoteIssueLink globalId(String globalId) {
        this.globalId = globalId;
        return this;
    }

    @ApiModelProperty(value="The global ID of the link, such as the ID of the item on the remote system.")
    public String getGlobalId() {
        return this.globalId;
    }

    public void setGlobalId(String globalId) {
        this.globalId = globalId;
    }

    public RemoteIssueLink id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the link.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RemoteIssueLink _object(RemoteObject _object) {
        this._object = _object;
        return this;
    }

    @ApiModelProperty(value="Details of the item linked to.")
    public RemoteObject getObject() {
        return this._object;
    }

    public void setObject(RemoteObject _object) {
        this._object = _object;
    }

    public RemoteIssueLink relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @ApiModelProperty(value="Description of the relationship between the issue and the linked item.")
    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public RemoteIssueLink self(URI self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(value="The URL of the link.")
    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteIssueLink remoteIssueLink = (RemoteIssueLink)o;
        return Objects.equals(this.application, remoteIssueLink.application) && Objects.equals(this.globalId, remoteIssueLink.globalId) && Objects.equals(this.id, remoteIssueLink.id) && Objects.equals(this._object, remoteIssueLink._object) && Objects.equals(this.relationship, remoteIssueLink.relationship) && Objects.equals(this.self, remoteIssueLink.self);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.globalId, this.id, this._object, this.relationship, this.self);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemoteIssueLink {\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    globalId: ").append(this.toIndentedString(this.globalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString(this.relationship)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

