/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.Scope;

@ApiModel(description="Details about a project role.")
public class ProjectRoleDetails {
    @JsonProperty(value="admin")
    private Boolean admin;
    @JsonProperty(value="default")
    private Boolean _default;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="roleConfigurable")
    private Boolean roleConfigurable;
    @JsonProperty(value="scope")
    private Scope scope;
    @JsonProperty(value="self")
    private URI self;
    @JsonProperty(value="translatedName")
    private String translatedName;

    @ApiModelProperty(value="Whether this role is the admin role for the project.")
    public Boolean getAdmin() {
        return this.admin;
    }

    @ApiModelProperty(value="Whether this role is the default role for the project.")
    public Boolean getDefault() {
        return this._default;
    }

    @ApiModelProperty(value="The description of the project role.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The ID of the project role.")
    public Long getId() {
        return this.id;
    }

    public ProjectRoleDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the project role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Whether the roles are configurable for this project.")
    public Boolean getRoleConfigurable() {
        return this.roleConfigurable;
    }

    @ApiModelProperty(value="The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).")
    public Scope getScope() {
        return this.scope;
    }

    @ApiModelProperty(value="The URL the project role details.")
    public URI getSelf() {
        return this.self;
    }

    public ProjectRoleDetails translatedName(String translatedName) {
        this.translatedName = translatedName;
        return this;
    }

    @ApiModelProperty(value="The translated name of the project role.")
    public String getTranslatedName() {
        return this.translatedName;
    }

    public void setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectRoleDetails projectRoleDetails = (ProjectRoleDetails)o;
        return Objects.equals(this.admin, projectRoleDetails.admin) && Objects.equals(this._default, projectRoleDetails._default) && Objects.equals(this.description, projectRoleDetails.description) && Objects.equals(this.id, projectRoleDetails.id) && Objects.equals(this.name, projectRoleDetails.name) && Objects.equals(this.roleConfigurable, projectRoleDetails.roleConfigurable) && Objects.equals(this.scope, projectRoleDetails.scope) && Objects.equals(this.self, projectRoleDetails.self) && Objects.equals(this.translatedName, projectRoleDetails.translatedName);
    }

    public int hashCode() {
        return Objects.hash(this.admin, this._default, this.description, this.id, this.name, this.roleConfigurable, this.scope, this.self, this.translatedName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectRoleDetails {\n");
        sb.append("    admin: ").append(this.toIndentedString(this.admin)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roleConfigurable: ").append(this.toIndentedString(this.roleConfigurable)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    translatedName: ").append(this.toIndentedString(this.translatedName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

