/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="Additional details about a project.")
public class ProjectInsight {
    @JsonProperty(value="lastIssueUpdateTime")
    private OffsetDateTime lastIssueUpdateTime;
    @JsonProperty(value="totalIssueCount")
    private Long totalIssueCount;

    @ApiModelProperty(value="The last issue update time.")
    public OffsetDateTime getLastIssueUpdateTime() {
        return this.lastIssueUpdateTime;
    }

    @ApiModelProperty(value="Total issue count.")
    public Long getTotalIssueCount() {
        return this.totalIssueCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectInsight projectInsight = (ProjectInsight)o;
        return Objects.equals(this.lastIssueUpdateTime, projectInsight.lastIssueUpdateTime) && Objects.equals(this.totalIssueCount, projectInsight.totalIssueCount);
    }

    public int hashCode() {
        return Objects.hash(this.lastIssueUpdateTime, this.totalIssueCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectInsight {\n");
        sb.append("    lastIssueUpdateTime: ").append(this.toIndentedString(this.lastIssueUpdateTime)).append("\n");
        sb.append("    totalIssueCount: ").append(this.toIndentedString(this.totalIssueCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

