/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.AvatarUrlsBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.UpdatedProjectCategory;

@ApiModel(description="Details about a project.")
public class ProjectDetails {
    @JsonProperty(value="avatarUrls")
    private AvatarUrlsBean avatarUrls;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="projectCategory")
    private UpdatedProjectCategory projectCategory;
    @JsonProperty(value="projectTypeKey")
    private ProjectTypeKeyEnum projectTypeKey;
    @JsonProperty(value="self")
    private String self;
    @JsonProperty(value="simplified")
    private Boolean simplified;

    @ApiModelProperty(value="The URLs of the project's avatars.")
    public AvatarUrlsBean getAvatarUrls() {
        return this.avatarUrls;
    }

    public ProjectDetails id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the project.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The key of the project.")
    public String getKey() {
        return this.key;
    }

    @ApiModelProperty(value="The name of the project.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The category the project belongs to.")
    public UpdatedProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    @ApiModelProperty(value="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.")
    public ProjectTypeKeyEnum getProjectTypeKey() {
        return this.projectTypeKey;
    }

    @ApiModelProperty(value="The URL of the project details.")
    public String getSelf() {
        return this.self;
    }

    @ApiModelProperty(value="Whether or not the project is simplified.")
    public Boolean getSimplified() {
        return this.simplified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDetails projectDetails = (ProjectDetails)o;
        return Objects.equals(this.avatarUrls, projectDetails.avatarUrls) && Objects.equals(this.id, projectDetails.id) && Objects.equals(this.key, projectDetails.key) && Objects.equals(this.name, projectDetails.name) && Objects.equals(this.projectCategory, projectDetails.projectCategory) && Objects.equals((Object)this.projectTypeKey, (Object)projectDetails.projectTypeKey) && Objects.equals(this.self, projectDetails.self) && Objects.equals(this.simplified, projectDetails.simplified);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.avatarUrls, this.id, this.key, this.name, this.projectCategory, this.projectTypeKey, this.self, this.simplified});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectDetails {\n");
        sb.append("    avatarUrls: ").append(this.toIndentedString(this.avatarUrls)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectCategory: ").append(this.toIndentedString(this.projectCategory)).append("\n");
        sb.append("    projectTypeKey: ").append(this.toIndentedString((Object)this.projectTypeKey)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    simplified: ").append(this.toIndentedString(this.simplified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProjectTypeKeyEnum {
        SOFTWARE("software"),
        SERVICE_DESK("service_desk"),
        BUSINESS("business");

        private String value;

        private ProjectTypeKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProjectTypeKeyEnum fromValue(String value) {
            for (ProjectTypeKeyEnum b : ProjectTypeKeyEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

