/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.PermissionHolder;

@ApiModel(description="Details about a permission granted to a user or group.")
public class PermissionGrant {
    @JsonProperty(value="holder")
    private PermissionHolder holder;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="permission")
    private String permission;
    @JsonProperty(value="self")
    private URI self;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public PermissionGrant holder(PermissionHolder holder) {
        this.holder = holder;
        return this;
    }

    @ApiModelProperty(value="The user or group being granted the permission. It consists of a `type`, a type-dependent `parameter` and a type-dependent `value`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.")
    public PermissionHolder getHolder() {
        return this.holder;
    }

    public void setHolder(PermissionHolder holder) {
        this.holder = holder;
    }

    @ApiModelProperty(value="The ID of the permission granted details.")
    public Long getId() {
        return this.id;
    }

    public PermissionGrant permission(String permission) {
        this.permission = permission;
        return this;
    }

    @ApiModelProperty(value="The permission to grant. This permission can be one of the built-in permissions or a custom permission added by an app. See [Built-in permissions](../api-group-permission-schemes/#built-in-permissions) in *Get all permission schemes* for more information about the built-in permissions. See the [project permission](https://developer.atlassian.com/cloud/jira/platform/modules/project-permission/) and [global permission](https://developer.atlassian.com/cloud/jira/platform/modules/global-permission/) module documentation for more information about custom permissions.")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @ApiModelProperty(value="The URL of the permission granted details.")
    public URI getSelf() {
        return this.self;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrant permissionGrant = (PermissionGrant)o;
        return Objects.equals(this.holder, permissionGrant.holder) && Objects.equals(this.id, permissionGrant.id) && Objects.equals(this.permission, permissionGrant.permission) && Objects.equals(this.self, permissionGrant.self) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.holder, this.id, this.permission, this.self, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionGrant {\n");
        sb.append("    holder: ").append(this.toIndentedString(this.holder)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

