/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQuery;

@ApiModel(description="Details of a parsed JQL query.")
public class ParsedJqlQuery {
    @JsonProperty(value="errors")
    private List<String> errors = new ArrayList<String>();
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="structure")
    private JqlQuery structure;

    public ParsedJqlQuery errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ParsedJqlQuery addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="The list of syntax or validation errors.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public ParsedJqlQuery query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="The JQL query that was parsed and validated.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ParsedJqlQuery structure(JqlQuery structure) {
        this.structure = structure;
        return this;
    }

    @ApiModelProperty(value="The syntax tree of the query. Empty if the query was invalid.")
    public JqlQuery getStructure() {
        return this.structure;
    }

    public void setStructure(JqlQuery structure) {
        this.structure = structure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedJqlQuery parsedJqlQuery = (ParsedJqlQuery)o;
        return Objects.equals(this.errors, parsedJqlQuery.errors) && Objects.equals(this.query, parsedJqlQuery.query) && Objects.equals(this.structure, parsedJqlQuery.structure);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.query, this.structure);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParsedJqlQuery {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    structure: ").append(this.toIndentedString(this.structure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

