/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An ordered list of custom field option IDs and information on where to move them.")
public class OrderOfCustomFieldOptions {
    @JsonProperty(value="after")
    private String after;
    @JsonProperty(value="customFieldOptionIds")
    private List<String> customFieldOptionIds = new ArrayList<String>();
    @JsonProperty(value="position")
    private PositionEnum position;

    public OrderOfCustomFieldOptions after(String after) {
        this.after = after;
        return this;
    }

    @ApiModelProperty(value="The ID of the custom field option or cascading option to place the moved options after. Required if `position` isn't provided.")
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public OrderOfCustomFieldOptions customFieldOptionIds(List<String> customFieldOptionIds) {
        this.customFieldOptionIds = customFieldOptionIds;
        return this;
    }

    public OrderOfCustomFieldOptions addCustomFieldOptionIdsItem(String customFieldOptionIdsItem) {
        this.customFieldOptionIds.add(customFieldOptionIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of IDs of custom field options to move. The order of the custom field option IDs in the list is the order they are given after the move. The list must contain custom field options or cascading options, but not both.")
    public List<String> getCustomFieldOptionIds() {
        return this.customFieldOptionIds;
    }

    public void setCustomFieldOptionIds(List<String> customFieldOptionIds) {
        this.customFieldOptionIds = customFieldOptionIds;
    }

    public OrderOfCustomFieldOptions position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="The position the custom field options should be moved to. Required if `after` isn't provided.")
    public PositionEnum getPosition() {
        return this.position;
    }

    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderOfCustomFieldOptions orderOfCustomFieldOptions = (OrderOfCustomFieldOptions)o;
        return Objects.equals(this.after, orderOfCustomFieldOptions.after) && Objects.equals(this.customFieldOptionIds, orderOfCustomFieldOptions.customFieldOptionIds) && Objects.equals((Object)this.position, (Object)orderOfCustomFieldOptions.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.after, this.customFieldOptionIds, this.position});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderOfCustomFieldOptions {\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    customFieldOptionIds: ").append(this.toIndentedString(this.customFieldOptionIds)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PositionEnum {
        FIRST("First"),
        LAST("Last");

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PositionEnum fromValue(String value) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

