/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.NotificationRecipients;
import org.everit.atlassian.restclient.jiracloud.v3.model.NotificationRecipientsRestrictions;

@ApiModel(description="Details about a notification.")
public class Notification {
    @JsonProperty(value="htmlBody")
    private String htmlBody;
    @JsonProperty(value="restrict")
    private NotificationRecipientsRestrictions restrict;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="textBody")
    private String textBody;
    @JsonProperty(value="to")
    private NotificationRecipients to;
    private HashMap<String, Object> additionalProperties_ = new HashMap();

    public Notification htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(value="The HTML body of the email notification for the issue.")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public Notification restrict(NotificationRecipientsRestrictions restrict) {
        this.restrict = restrict;
        return this;
    }

    @ApiModelProperty(value="Restricts the notifications to users with the specified permissions.")
    public NotificationRecipientsRestrictions getRestrict() {
        return this.restrict;
    }

    public void setRestrict(NotificationRecipientsRestrictions restrict) {
        this.restrict = restrict;
    }

    public Notification subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="The subject of the email notification for the issue. If this is not specified, then the subject is set to the issue key and summary.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Notification textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(value="The plain text body of the email notification for the issue.")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public Notification to(NotificationRecipients to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(value="The recipients of the email notification for the issue.")
    public NotificationRecipients getTo() {
        return this.to;
    }

    public void setTo(NotificationRecipients to) {
        this.to = to;
    }

    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.additionalProperties_;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalProperties_.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification notification = (Notification)o;
        return Objects.equals(this.htmlBody, notification.htmlBody) && Objects.equals(this.restrict, notification.restrict) && Objects.equals(this.subject, notification.subject) && Objects.equals(this.textBody, notification.textBody) && Objects.equals(this.to, notification.to) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.htmlBody, this.restrict, this.subject, this.textBody, this.to, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Notification {\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    restrict: ").append(this.toIndentedString(this.restrict)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties_)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

