/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A metric that provides insight into the active licence details")
public class LicenseMetric {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="value")
    private String value;

    public LicenseMetric key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The key of a specific license metric.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public LicenseMetric value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The calculated value of a licence metric linked to the key. An example licence metric is the approximate number of user accounts.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseMetric licenseMetric = (LicenseMetric)o;
        return Objects.equals(this.key, licenseMetric.key) && Objects.equals(this.value, licenseMetric.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LicenseMetric {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

