/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An operand that can be part of a list operand.")
public class JqlQueryUnitaryOperand {
    @JsonProperty(value="encodedValue")
    private String encodedValue;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="arguments")
    private List<String> arguments = new ArrayList<String>();
    @JsonProperty(value="encodedOperand")
    private String encodedOperand;
    @JsonProperty(value="function")
    private String function;
    @JsonProperty(value="keyword")
    private KeywordEnum keyword;

    public JqlQueryUnitaryOperand encodedValue(String encodedValue) {
        this.encodedValue = encodedValue;
        return this;
    }

    @ApiModelProperty(value="Encoded value, which can be used directly in a JQL query.")
    public String getEncodedValue() {
        return this.encodedValue;
    }

    public void setEncodedValue(String encodedValue) {
        this.encodedValue = encodedValue;
    }

    public JqlQueryUnitaryOperand value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="The operand value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public JqlQueryUnitaryOperand arguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public JqlQueryUnitaryOperand addArgumentsItem(String argumentsItem) {
        this.arguments.add(argumentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of function arguments.")
    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public JqlQueryUnitaryOperand encodedOperand(String encodedOperand) {
        this.encodedOperand = encodedOperand;
        return this;
    }

    @ApiModelProperty(value="Encoded operand, which can be used directly in a JQL query.")
    public String getEncodedOperand() {
        return this.encodedOperand;
    }

    public void setEncodedOperand(String encodedOperand) {
        this.encodedOperand = encodedOperand;
    }

    public JqlQueryUnitaryOperand function(String function) {
        this.function = function;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the function.")
    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public JqlQueryUnitaryOperand keyword(KeywordEnum keyword) {
        this.keyword = keyword;
        return this;
    }

    @ApiModelProperty(required=true, value="The keyword that is the operand value.")
    public KeywordEnum getKeyword() {
        return this.keyword;
    }

    public void setKeyword(KeywordEnum keyword) {
        this.keyword = keyword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JqlQueryUnitaryOperand jqlQueryUnitaryOperand = (JqlQueryUnitaryOperand)o;
        return Objects.equals(this.encodedValue, jqlQueryUnitaryOperand.encodedValue) && Objects.equals(this.value, jqlQueryUnitaryOperand.value) && Objects.equals(this.arguments, jqlQueryUnitaryOperand.arguments) && Objects.equals(this.encodedOperand, jqlQueryUnitaryOperand.encodedOperand) && Objects.equals(this.function, jqlQueryUnitaryOperand.function) && Objects.equals((Object)this.keyword, (Object)jqlQueryUnitaryOperand.keyword);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.encodedValue, this.value, this.arguments, this.encodedOperand, this.function, this.keyword});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JqlQueryUnitaryOperand {\n");
        sb.append("    encodedValue: ").append(this.toIndentedString(this.encodedValue)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    encodedOperand: ").append(this.toIndentedString(this.encodedOperand)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    keyword: ").append(this.toIndentedString((Object)this.keyword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KeywordEnum {
        EMPTY("empty");

        private String value;

        private KeywordEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeywordEnum fromValue(String value) {
            for (KeywordEnum b : KeywordEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

