/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectIssueTypes;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowScope;

@ApiModel(description="Details of a status.")
public class JiraWorkflowStatus {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="scope")
    private WorkflowScope scope;
    @JsonProperty(value="statusCategory")
    private StatusCategoryEnum statusCategory;
    @JsonProperty(value="statusReference")
    private String statusReference;
    @JsonProperty(value="usages")
    private List<ProjectIssueTypes> usages = new ArrayList<ProjectIssueTypes>();

    public JiraWorkflowStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the status.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraWorkflowStatus id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the status.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JiraWorkflowStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the status.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JiraWorkflowStatus scope(WorkflowScope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="")
    public WorkflowScope getScope() {
        return this.scope;
    }

    public void setScope(WorkflowScope scope) {
        this.scope = scope;
    }

    public JiraWorkflowStatus statusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
        return this;
    }

    @ApiModelProperty(value="The category of the status.")
    public StatusCategoryEnum getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(StatusCategoryEnum statusCategory) {
        this.statusCategory = statusCategory;
    }

    public JiraWorkflowStatus statusReference(String statusReference) {
        this.statusReference = statusReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the status.")
    public String getStatusReference() {
        return this.statusReference;
    }

    public void setStatusReference(String statusReference) {
        this.statusReference = statusReference;
    }

    public JiraWorkflowStatus usages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
        return this;
    }

    public JiraWorkflowStatus addUsagesItem(ProjectIssueTypes usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<ProjectIssueTypes>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @ApiModelProperty(value="The `statuses.usages` expand is an optional parameter that can be used when reading and updating statuses in Jira. It provides additional information about the projects and issue types associated with the requested statuses.")
    public List<ProjectIssueTypes> getUsages() {
        return this.usages;
    }

    public void setUsages(List<ProjectIssueTypes> usages) {
        this.usages = usages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraWorkflowStatus jiraWorkflowStatus = (JiraWorkflowStatus)o;
        return Objects.equals(this.description, jiraWorkflowStatus.description) && Objects.equals(this.id, jiraWorkflowStatus.id) && Objects.equals(this.name, jiraWorkflowStatus.name) && Objects.equals(this.scope, jiraWorkflowStatus.scope) && Objects.equals((Object)this.statusCategory, (Object)jiraWorkflowStatus.statusCategory) && Objects.equals(this.statusReference, jiraWorkflowStatus.statusReference) && Objects.equals(this.usages, jiraWorkflowStatus.usages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.id, this.name, this.scope, this.statusCategory, this.statusReference, this.usages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JiraWorkflowStatus {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    statusCategory: ").append(this.toIndentedString((Object)this.statusCategory)).append("\n");
        sb.append("    statusReference: ").append(this.toIndentedString(this.statusReference)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusCategoryEnum {
        TODO("TODO"),
        IN_PROGRESS("IN_PROGRESS"),
        DONE("DONE");

        private String value;

        private StatusCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusCategoryEnum fromValue(String value) {
            for (StatusCategoryEnum b : StatusCategoryEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

