/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details about the mapping between issue types and a workflow.")
public class IssueTypesWorkflowMapping {
    @JsonProperty(value="defaultMapping")
    private Boolean defaultMapping;
    @JsonProperty(value="issueTypes")
    private List<String> issueTypes = new ArrayList<String>();
    @JsonProperty(value="updateDraftIfNeeded")
    private Boolean updateDraftIfNeeded;
    @JsonProperty(value="workflow")
    private String workflow;

    public IssueTypesWorkflowMapping defaultMapping(Boolean defaultMapping) {
        this.defaultMapping = defaultMapping;
        return this;
    }

    @ApiModelProperty(value="Whether the workflow is the default workflow for the workflow scheme.")
    public Boolean getDefaultMapping() {
        return this.defaultMapping;
    }

    public void setDefaultMapping(Boolean defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public IssueTypesWorkflowMapping issueTypes(List<String> issueTypes) {
        this.issueTypes = issueTypes;
        return this;
    }

    public IssueTypesWorkflowMapping addIssueTypesItem(String issueTypesItem) {
        if (this.issueTypes == null) {
            this.issueTypes = new ArrayList<String>();
        }
        this.issueTypes.add(issueTypesItem);
        return this;
    }

    @ApiModelProperty(value="The list of issue type IDs.")
    public List<String> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(List<String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public IssueTypesWorkflowMapping updateDraftIfNeeded(Boolean updateDraftIfNeeded) {
        this.updateDraftIfNeeded = updateDraftIfNeeded;
        return this;
    }

    @ApiModelProperty(value="Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new workflow-issue types mapping. Defaults to `false`.")
    public Boolean getUpdateDraftIfNeeded() {
        return this.updateDraftIfNeeded;
    }

    public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
        this.updateDraftIfNeeded = updateDraftIfNeeded;
    }

    public IssueTypesWorkflowMapping workflow(String workflow) {
        this.workflow = workflow;
        return this;
    }

    @ApiModelProperty(value="The name of the workflow. Optional if updating the workflow-issue types mapping.")
    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueTypesWorkflowMapping issueTypesWorkflowMapping = (IssueTypesWorkflowMapping)o;
        return Objects.equals(this.defaultMapping, issueTypesWorkflowMapping.defaultMapping) && Objects.equals(this.issueTypes, issueTypesWorkflowMapping.issueTypes) && Objects.equals(this.updateDraftIfNeeded, issueTypesWorkflowMapping.updateDraftIfNeeded) && Objects.equals(this.workflow, issueTypesWorkflowMapping.workflow);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMapping, this.issueTypes, this.updateDraftIfNeeded, this.workflow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueTypesWorkflowMapping {\n");
        sb.append("    defaultMapping: ").append(this.toIndentedString(this.defaultMapping)).append("\n");
        sb.append("    issueTypes: ").append(this.toIndentedString(this.issueTypes)).append("\n");
        sb.append("    updateDraftIfNeeded: ").append(this.toIndentedString(this.updateDraftIfNeeded)).append("\n");
        sb.append("    workflow: ").append(this.toIndentedString(this.workflow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

