/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A list of the issues matched to a JQL query or details of errors encountered during matching.")
public class IssueMatchesForJQL {
    @JsonProperty(value="errors")
    private List<String> errors = new ArrayList<String>();
    @JsonProperty(value="matchedIssues")
    private List<Long> matchedIssues = new ArrayList<Long>();

    public IssueMatchesForJQL errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public IssueMatchesForJQL addErrorsItem(String errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of errors.")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public IssueMatchesForJQL matchedIssues(List<Long> matchedIssues) {
        this.matchedIssues = matchedIssues;
        return this;
    }

    public IssueMatchesForJQL addMatchedIssuesItem(Long matchedIssuesItem) {
        this.matchedIssues.add(matchedIssuesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of issue IDs.")
    public List<Long> getMatchedIssues() {
        return this.matchedIssues;
    }

    public void setMatchedIssues(List<Long> matchedIssues) {
        this.matchedIssues = matchedIssues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueMatchesForJQL issueMatchesForJQL = (IssueMatchesForJQL)o;
        return Objects.equals(this.errors, issueMatchesForJQL.errors) && Objects.equals(this.matchedIssues, issueMatchesForJQL.matchedIssues);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.matchedIssues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueMatchesForJQL {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    matchedIssues: ").append(this.toIndentedString(this.matchedIssues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

