/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JsonNode;

@ApiModel(description="An issue ID with entity property values. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.")
public class IssueEntityPropertiesForMultiUpdate {
    @JsonProperty(value="issueID")
    private Long issueID;
    @JsonProperty(value="properties")
    private Map<String, JsonNode> properties = new HashMap<String, JsonNode>();

    public IssueEntityPropertiesForMultiUpdate issueID(Long issueID) {
        this.issueID = issueID;
        return this;
    }

    @ApiModelProperty(value="The ID of the issue.")
    public Long getIssueID() {
        return this.issueID;
    }

    public void setIssueID(Long issueID) {
        this.issueID = issueID;
    }

    public IssueEntityPropertiesForMultiUpdate properties(Map<String, JsonNode> properties) {
        this.properties = properties;
        return this;
    }

    public IssueEntityPropertiesForMultiUpdate putPropertiesItem(String key, JsonNode propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, JsonNode>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Entity properties to set on the issue. The maximum length of an issue property value is 32768 characters.")
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, JsonNode> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueEntityPropertiesForMultiUpdate issueEntityPropertiesForMultiUpdate = (IssueEntityPropertiesForMultiUpdate)o;
        return Objects.equals(this.issueID, issueEntityPropertiesForMultiUpdate.issueID) && Objects.equals(this.properties, issueEntityPropertiesForMultiUpdate.properties);
    }

    public int hashCode() {
        return Objects.hash(this.issueID, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueEntityPropertiesForMultiUpdate {\n");
        sb.append("    issueID: ").append(this.toIndentedString(this.issueID)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

