/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryClauseOperand;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryClauseTimePredicate;
import org.everit.atlassian.restclient.jiracloud.v3.model.JqlQueryField;

@ApiModel(description="A clause that asserts a previous value of a field. For example, `status WAS \"Resolved\" BY currentUser() BEFORE \"2019/02/02\"`. See [WAS](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-WASWAS) for more information about the WAS operator.")
public class FieldWasClause {
    @JsonProperty(value="field")
    private JqlQueryField field;
    @JsonProperty(value="operand")
    private JqlQueryClauseOperand operand;
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonProperty(value="predicates")
    private List<JqlQueryClauseTimePredicate> predicates = new ArrayList<JqlQueryClauseTimePredicate>();

    public FieldWasClause field(JqlQueryField field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryField getField() {
        return this.field;
    }

    public void setField(JqlQueryField field) {
        this.field = field;
    }

    public FieldWasClause operand(JqlQueryClauseOperand operand) {
        this.operand = operand;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public JqlQueryClauseOperand getOperand() {
        return this.operand;
    }

    public void setOperand(JqlQueryClauseOperand operand) {
        this.operand = operand;
    }

    public FieldWasClause operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="The operator between the field and operand.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public FieldWasClause predicates(List<JqlQueryClauseTimePredicate> predicates) {
        this.predicates = predicates;
        return this;
    }

    public FieldWasClause addPredicatesItem(JqlQueryClauseTimePredicate predicatesItem) {
        this.predicates.add(predicatesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of time predicates.")
    public List<JqlQueryClauseTimePredicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(List<JqlQueryClauseTimePredicate> predicates) {
        this.predicates = predicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldWasClause fieldWasClause = (FieldWasClause)o;
        return Objects.equals(this.field, fieldWasClause.field) && Objects.equals(this.operand, fieldWasClause.operand) && Objects.equals((Object)this.operator, (Object)fieldWasClause.operator) && Objects.equals(this.predicates, fieldWasClause.predicates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.operand, this.operator, this.predicates});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldWasClause {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    operand: ").append(this.toIndentedString(this.operand)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    predicates: ").append(this.toIndentedString(this.predicates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        WAS("was"),
        WAS_IN("was in"),
        WAS_NOT_IN("was not in"),
        WAS_NOT("was not");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

