/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Details of an operation to perform on a field.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldUpdateOperation {
    @JsonProperty(value="add")
    private Object add = null;
    @JsonProperty(value="copy")
    private Object copy = null;
    @JsonProperty(value="edit")
    private Object edit = null;
    @JsonProperty(value="remove")
    private Object remove = null;
    @JsonProperty(value="set")
    private Object set = null;

    public FieldUpdateOperation add(Object add) {
        this.add = add;
        return this;
    }

    @ApiModelProperty(example="triaged", value="The value to add to the field.")
    public Object getAdd() {
        return this.add;
    }

    public void setAdd(Object add) {
        this.add = add;
    }

    public FieldUpdateOperation copy(Object copy) {
        this.copy = copy;
        return this;
    }

    @ApiModelProperty(example="{\"issuelinks\":{\"sourceIssues\":[{\"key\":\"FP-5\"}]}}", value="The field value to copy from another issue.")
    public Object getCopy() {
        return this.copy;
    }

    public void setCopy(Object copy) {
        this.copy = copy;
    }

    public FieldUpdateOperation edit(Object edit) {
        this.edit = edit;
        return this;
    }

    @ApiModelProperty(example="{\"originalEstimate\":\"1w 1d\",\"remainingEstimate\":\"4d\"}", value="The value to edit in the field.")
    public Object getEdit() {
        return this.edit;
    }

    public void setEdit(Object edit) {
        this.edit = edit;
    }

    public FieldUpdateOperation remove(Object remove) {
        this.remove = remove;
        return this;
    }

    @ApiModelProperty(example="blocker", value="The value to removed from the field.")
    public Object getRemove() {
        return this.remove;
    }

    public void setRemove(Object remove) {
        this.remove = remove;
    }

    public FieldUpdateOperation set(Object set) {
        this.set = set;
        return this;
    }

    @ApiModelProperty(example="A new summary", value="The value to set in the field.")
    public Object getSet() {
        return this.set;
    }

    public void setSet(Object set) {
        this.set = set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldUpdateOperation fieldUpdateOperation = (FieldUpdateOperation)o;
        return Objects.equals(this.add, fieldUpdateOperation.add) && Objects.equals(this.copy, fieldUpdateOperation.copy) && Objects.equals(this.edit, fieldUpdateOperation.edit) && Objects.equals(this.remove, fieldUpdateOperation.remove) && Objects.equals(this.set, fieldUpdateOperation.set);
    }

    public int hashCode() {
        return Objects.hash(this.add, this.copy, this.edit, this.remove, this.set);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldUpdateOperation {\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    copy: ").append(this.toIndentedString(this.copy)).append("\n");
        sb.append("    edit: ").append(this.toIndentedString(this.edit)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    set: ").append(this.toIndentedString(this.set)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

