/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of a field that can be used in advanced searches.")
public class FieldReferenceData {
    @JsonProperty(value="auto")
    private AutoEnum auto;
    @JsonProperty(value="cfid")
    private String cfid;
    @JsonProperty(value="deprecated")
    private DeprecatedEnum deprecated;
    @JsonProperty(value="deprecatedSearcherKey")
    private String deprecatedSearcherKey;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="operators")
    private List<String> operators = new ArrayList<String>();
    @JsonProperty(value="orderable")
    private OrderableEnum orderable;
    @JsonProperty(value="searchable")
    private SearchableEnum searchable;
    @JsonProperty(value="types")
    private List<String> types = new ArrayList<String>();
    @JsonProperty(value="value")
    private String value;

    public FieldReferenceData auto(AutoEnum auto) {
        this.auto = auto;
        return this;
    }

    @ApiModelProperty(value="Whether the field provide auto-complete suggestions.")
    public AutoEnum getAuto() {
        return this.auto;
    }

    public void setAuto(AutoEnum auto) {
        this.auto = auto;
    }

    public FieldReferenceData cfid(String cfid) {
        this.cfid = cfid;
        return this;
    }

    @ApiModelProperty(value="If the item is a custom field, the ID of the custom field.")
    public String getCfid() {
        return this.cfid;
    }

    public void setCfid(String cfid) {
        this.cfid = cfid;
    }

    public FieldReferenceData deprecated(DeprecatedEnum deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @ApiModelProperty(value="Whether this field has been deprecated.")
    public DeprecatedEnum getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(DeprecatedEnum deprecated) {
        this.deprecated = deprecated;
    }

    public FieldReferenceData deprecatedSearcherKey(String deprecatedSearcherKey) {
        this.deprecatedSearcherKey = deprecatedSearcherKey;
        return this;
    }

    @ApiModelProperty(value="The searcher key of the field, only passed when the field is deprecated.")
    public String getDeprecatedSearcherKey() {
        return this.deprecatedSearcherKey;
    }

    public void setDeprecatedSearcherKey(String deprecatedSearcherKey) {
        this.deprecatedSearcherKey = deprecatedSearcherKey;
    }

    public FieldReferenceData displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name contains the following:   *  for system fields, the field name. For example, `Summary`.  *  for collapsed custom fields, the field name followed by a hyphen and then the field name and field type. For example, `Component - Component[Dropdown]`.  *  for other custom fields, the field name followed by a hyphen and then the custom field ID. For example, `Component - cf[10061]`.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public FieldReferenceData operators(List<String> operators) {
        this.operators = operators;
        return this;
    }

    public FieldReferenceData addOperatorsItem(String operatorsItem) {
        if (this.operators == null) {
            this.operators = new ArrayList<String>();
        }
        this.operators.add(operatorsItem);
        return this;
    }

    @ApiModelProperty(value="The valid search operators for the field.")
    public List<String> getOperators() {
        return this.operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public FieldReferenceData orderable(OrderableEnum orderable) {
        this.orderable = orderable;
        return this;
    }

    @ApiModelProperty(value="Whether the field can be used in a query's `ORDER BY` clause.")
    public OrderableEnum getOrderable() {
        return this.orderable;
    }

    public void setOrderable(OrderableEnum orderable) {
        this.orderable = orderable;
    }

    public FieldReferenceData searchable(SearchableEnum searchable) {
        this.searchable = searchable;
        return this;
    }

    @ApiModelProperty(value="Whether the content of this field can be searched.")
    public SearchableEnum getSearchable() {
        return this.searchable;
    }

    public void setSearchable(SearchableEnum searchable) {
        this.searchable = searchable;
    }

    public FieldReferenceData types(List<String> types) {
        this.types = types;
        return this;
    }

    public FieldReferenceData addTypesItem(String typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="The data types of items in the field.")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public FieldReferenceData value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The field identifier.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReferenceData fieldReferenceData = (FieldReferenceData)o;
        return Objects.equals((Object)this.auto, (Object)fieldReferenceData.auto) && Objects.equals(this.cfid, fieldReferenceData.cfid) && Objects.equals((Object)this.deprecated, (Object)fieldReferenceData.deprecated) && Objects.equals(this.deprecatedSearcherKey, fieldReferenceData.deprecatedSearcherKey) && Objects.equals(this.displayName, fieldReferenceData.displayName) && Objects.equals(this.operators, fieldReferenceData.operators) && Objects.equals((Object)this.orderable, (Object)fieldReferenceData.orderable) && Objects.equals((Object)this.searchable, (Object)fieldReferenceData.searchable) && Objects.equals(this.types, fieldReferenceData.types) && Objects.equals(this.value, fieldReferenceData.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auto, this.cfid, this.deprecated, this.deprecatedSearcherKey, this.displayName, this.operators, this.orderable, this.searchable, this.types, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldReferenceData {\n");
        sb.append("    auto: ").append(this.toIndentedString((Object)this.auto)).append("\n");
        sb.append("    cfid: ").append(this.toIndentedString(this.cfid)).append("\n");
        sb.append("    deprecated: ").append(this.toIndentedString((Object)this.deprecated)).append("\n");
        sb.append("    deprecatedSearcherKey: ").append(this.toIndentedString(this.deprecatedSearcherKey)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    operators: ").append(this.toIndentedString(this.operators)).append("\n");
        sb.append("    orderable: ").append(this.toIndentedString((Object)this.orderable)).append("\n");
        sb.append("    searchable: ").append(this.toIndentedString((Object)this.searchable)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SearchableEnum {
        TRUE("true"),
        FALSE("false");

        private String value;

        private SearchableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SearchableEnum fromValue(String value) {
            for (SearchableEnum b : SearchableEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OrderableEnum {
        TRUE("true"),
        FALSE("false");

        private String value;

        private OrderableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderableEnum fromValue(String value) {
            for (OrderableEnum b : OrderableEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DeprecatedEnum {
        TRUE("true"),
        FALSE("false");

        private String value;

        private DeprecatedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeprecatedEnum fromValue(String value) {
            for (DeprecatedEnum b : DeprecatedEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AutoEnum {
        TRUE("true"),
        FALSE("false");

        private String value;

        private AutoEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AutoEnum fromValue(String value) {
            for (AutoEnum b : AutoEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

