/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.FieldDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.GroupName;
import org.everit.atlassian.restclient.jiracloud.v3.model.ProjectRole;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;

@ApiModel(description="Details about a notification associated with an event.")
public class EventNotification {
    @JsonProperty(value="emailAddress")
    private String emailAddress;
    @JsonProperty(value="expand")
    private String expand;
    @JsonProperty(value="field")
    private FieldDetails field;
    @JsonProperty(value="group")
    private GroupName group;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="notificationType")
    private NotificationTypeEnum notificationType;
    @JsonProperty(value="parameter")
    private String parameter;
    @JsonProperty(value="projectRole")
    private ProjectRole projectRole;
    @JsonProperty(value="recipient")
    private String recipient;
    @JsonProperty(value="user")
    private UserDetails user;

    public EventNotification emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="The email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public EventNotification expand(String expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(value="Expand options that include additional event notification details in the response.")
    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public EventNotification field(FieldDetails field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(value="The custom user or group field.")
    public FieldDetails getField() {
        return this.field;
    }

    public void setField(FieldDetails field) {
        this.field = field;
    }

    public EventNotification group(GroupName group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="The specified group.")
    public GroupName getGroup() {
        return this.group;
    }

    public void setGroup(GroupName group) {
        this.group = group;
    }

    public EventNotification id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the notification.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EventNotification notificationType(NotificationTypeEnum notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    @ApiModelProperty(value="Identifies the recipients of the notification.")
    public NotificationTypeEnum getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(NotificationTypeEnum notificationType) {
        this.notificationType = notificationType;
    }

    public EventNotification parameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @ApiModelProperty(value="As a group's name can change, use of `recipient` is recommended. The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by `notificationType` value. So, when `notificationType` is:   *  `User` The `parameter` is the user account ID.  *  `Group` The `parameter` is the group name.  *  `ProjectRole` The `parameter` is the project role ID.  *  `UserCustomField` The `parameter` is the ID of the custom field.  *  `GroupCustomField` The `parameter` is the ID of the custom field.")
    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public EventNotification projectRole(ProjectRole projectRole) {
        this.projectRole = projectRole;
        return this;
    }

    @ApiModelProperty(value="The specified project role.")
    public ProjectRole getProjectRole() {
        return this.projectRole;
    }

    public void setProjectRole(ProjectRole projectRole) {
        this.projectRole = projectRole;
    }

    public EventNotification recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(value="The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by the `notificationType` value. So, when `notificationType` is:   *  `User`, `recipient` is the user account ID.  *  `Group`, `recipient` is the group ID.  *  `ProjectRole`, `recipient` is the project role ID.  *  `UserCustomField`, `recipient` is the ID of the custom field.  *  `GroupCustomField`, `recipient` is the ID of the custom field.")
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public EventNotification user(UserDetails user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="The specified user.")
    public UserDetails getUser() {
        return this.user;
    }

    public void setUser(UserDetails user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventNotification eventNotification = (EventNotification)o;
        return Objects.equals(this.emailAddress, eventNotification.emailAddress) && Objects.equals(this.expand, eventNotification.expand) && Objects.equals(this.field, eventNotification.field) && Objects.equals(this.group, eventNotification.group) && Objects.equals(this.id, eventNotification.id) && Objects.equals((Object)this.notificationType, (Object)eventNotification.notificationType) && Objects.equals(this.parameter, eventNotification.parameter) && Objects.equals(this.projectRole, eventNotification.projectRole) && Objects.equals(this.recipient, eventNotification.recipient) && Objects.equals(this.user, eventNotification.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.emailAddress, this.expand, this.field, this.group, this.id, this.notificationType, this.parameter, this.projectRole, this.recipient, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventNotification {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    notificationType: ").append(this.toIndentedString((Object)this.notificationType)).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("    projectRole: ").append(this.toIndentedString(this.projectRole)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NotificationTypeEnum {
        CURRENTASSIGNEE("CurrentAssignee"),
        REPORTER("Reporter"),
        CURRENTUSER("CurrentUser"),
        PROJECTLEAD("ProjectLead"),
        COMPONENTLEAD("ComponentLead"),
        USER("User"),
        GROUP("Group"),
        PROJECTROLE("ProjectRole"),
        EMAILADDRESS("EmailAddress"),
        ALLWATCHERS("AllWatchers"),
        USERCUSTOMFIELD("UserCustomField"),
        GROUPCUSTOMFIELD("GroupCustomField");

        private String value;

        private NotificationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NotificationTypeEnum fromValue(String value) {
            for (NotificationTypeEnum b : NotificationTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

