/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.DashboardGadgetPosition;

@ApiModel(description="Details of a gadget.")
public class DashboardGadget {
    @JsonProperty(value="color")
    private ColorEnum color;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="moduleKey")
    private String moduleKey;
    @JsonProperty(value="position")
    private DashboardGadgetPosition position;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="uri")
    private String uri;

    @ApiModelProperty(required=true, value="The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.")
    public ColorEnum getColor() {
        return this.color;
    }

    @ApiModelProperty(required=true, value="The ID of the gadget instance.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The module key of the gadget type.")
    public String getModuleKey() {
        return this.moduleKey;
    }

    @ApiModelProperty(required=true, value="The position of the gadget.")
    public DashboardGadgetPosition getPosition() {
        return this.position;
    }

    @ApiModelProperty(required=true, value="The title of the gadget.")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(value="The URI of the gadget type.")
    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardGadget dashboardGadget = (DashboardGadget)o;
        return Objects.equals((Object)this.color, (Object)dashboardGadget.color) && Objects.equals(this.id, dashboardGadget.id) && Objects.equals(this.moduleKey, dashboardGadget.moduleKey) && Objects.equals(this.position, dashboardGadget.position) && Objects.equals(this.title, dashboardGadget.title) && Objects.equals(this.uri, dashboardGadget.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.id, this.moduleKey, this.position, this.title, this.uri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardGadget {\n");
        sb.append("    color: ").append(this.toIndentedString((Object)this.color)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    moduleKey: ").append(this.toIndentedString(this.moduleKey)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ColorEnum {
        BLUE("blue"),
        RED("red"),
        YELLOW("yellow"),
        GREEN("green"),
        CYAN("cyan"),
        PURPLE("purple"),
        GRAY("gray"),
        WHITE("white");

        private String value;

        private ColorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ColorEnum fromValue(String value) {
            for (ColorEnum b : ColorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

