/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A workflow transition condition.")
public class CreateWorkflowCondition {
    @JsonProperty(value="conditions")
    private List<CreateWorkflowCondition> conditions = new ArrayList<CreateWorkflowCondition>();
    @JsonProperty(value="configuration")
    private Map<String, Object> _configuration = new HashMap<String, Object>();
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonProperty(value="type")
    private String type;

    public CreateWorkflowCondition conditions(List<CreateWorkflowCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public CreateWorkflowCondition addConditionsItem(CreateWorkflowCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<CreateWorkflowCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="The list of workflow conditions.")
    public List<CreateWorkflowCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<CreateWorkflowCondition> conditions) {
        this.conditions = conditions;
    }

    public CreateWorkflowCondition _configuration(Map<String, Object> _configuration) {
        this._configuration = _configuration;
        return this;
    }

    public CreateWorkflowCondition putConfigurationItem(String key, Object _configurationItem) {
        if (this._configuration == null) {
            this._configuration = new HashMap<String, Object>();
        }
        this._configuration.put(key, _configurationItem);
        return this;
    }

    @ApiModelProperty(value="EXPERIMENTAL. The configuration of the transition rule.")
    public Map<String, Object> getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Map<String, Object> _configuration) {
        this._configuration = _configuration;
    }

    public CreateWorkflowCondition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(value="The compound condition operator.")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public CreateWorkflowCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the transition rule.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkflowCondition createWorkflowCondition = (CreateWorkflowCondition)o;
        return Objects.equals(this.conditions, createWorkflowCondition.conditions) && Objects.equals(this._configuration, createWorkflowCondition._configuration) && Objects.equals((Object)this.operator, (Object)createWorkflowCondition.operator) && Objects.equals(this.type, createWorkflowCondition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this._configuration, this.operator, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkflowCondition {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        AND("AND"),
        OR("OR");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

