/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="A list of custom field details.")
public class ConnectCustomFieldValue {
    @JsonProperty(value="_type")
    private TypeEnum type;
    @JsonProperty(value="fieldID")
    private Integer fieldID;
    @JsonProperty(value="issueID")
    private Integer issueID;
    @JsonProperty(value="number")
    private BigDecimal number;
    @JsonProperty(value="optionID")
    private String optionID;
    @JsonProperty(value="richText")
    private String richText;
    @JsonProperty(value="string")
    private String string;
    @JsonProperty(value="text")
    private String text;

    public ConnectCustomFieldValue type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of custom field.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConnectCustomFieldValue fieldID(Integer fieldID) {
        this.fieldID = fieldID;
        return this;
    }

    @ApiModelProperty(required=true, value="The custom field ID.")
    public Integer getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(Integer fieldID) {
        this.fieldID = fieldID;
    }

    public ConnectCustomFieldValue issueID(Integer issueID) {
        this.issueID = issueID;
        return this;
    }

    @ApiModelProperty(required=true, value="The issue ID.")
    public Integer getIssueID() {
        return this.issueID;
    }

    public void setIssueID(Integer issueID) {
        this.issueID = issueID;
    }

    public ConnectCustomFieldValue number(BigDecimal number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The value of number type custom field when `_type` is `NumberIssueField`.")
    public BigDecimal getNumber() {
        return this.number;
    }

    public void setNumber(BigDecimal number) {
        this.number = number;
    }

    public ConnectCustomFieldValue optionID(String optionID) {
        this.optionID = optionID;
        return this;
    }

    @ApiModelProperty(value="The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.")
    public String getOptionID() {
        return this.optionID;
    }

    public void setOptionID(String optionID) {
        this.optionID = optionID;
    }

    public ConnectCustomFieldValue richText(String richText) {
        this.richText = richText;
        return this;
    }

    @ApiModelProperty(value="The value of richText type custom field when `_type` is `RichTextIssueField`.")
    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String richText) {
        this.richText = richText;
    }

    public ConnectCustomFieldValue string(String string) {
        this.string = string;
        return this;
    }

    @ApiModelProperty(value="The value of string type custom field when `_type` is `StringIssueField`.")
    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public ConnectCustomFieldValue text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The value of of text custom field type when `_type` is `TextIssueField`.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectCustomFieldValue connectCustomFieldValue = (ConnectCustomFieldValue)o;
        return Objects.equals((Object)this.type, (Object)connectCustomFieldValue.type) && Objects.equals(this.fieldID, connectCustomFieldValue.fieldID) && Objects.equals(this.issueID, connectCustomFieldValue.issueID) && Objects.equals(this.number, connectCustomFieldValue.number) && Objects.equals(this.optionID, connectCustomFieldValue.optionID) && Objects.equals(this.richText, connectCustomFieldValue.richText) && Objects.equals(this.string, connectCustomFieldValue.string) && Objects.equals(this.text, connectCustomFieldValue.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.fieldID, this.issueID, this.number, this.optionID, this.richText, this.string, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectCustomFieldValue {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fieldID: ").append(this.toIndentedString(this.fieldID)).append("\n");
        sb.append("    issueID: ").append(this.toIndentedString(this.issueID)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    optionID: ").append(this.toIndentedString(this.optionID)).append("\n");
        sb.append("    richText: ").append(this.toIndentedString(this.richText)).append("\n");
        sb.append("    string: ").append(this.toIndentedString(this.string)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        STRINGISSUEFIELD("StringIssueField"),
        NUMBERISSUEFIELD("NumberIssueField"),
        RICHTEXTISSUEFIELD("RichTextIssueField"),
        SINGLESELECTISSUEFIELD("SingleSelectIssueField"),
        MULTISELECTISSUEFIELD("MultiSelectIssueField"),
        TEXTISSUEFIELD("TextIssueField");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

