/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.WorkflowRuleConfiguration;

@ApiModel(description="The conditions group associated with the transition.")
public class ConditionGroupUpdate {
    @JsonProperty(value="conditionGroups")
    private List<ConditionGroupUpdate> conditionGroups = new ArrayList<ConditionGroupUpdate>();
    @JsonProperty(value="conditions")
    private List<WorkflowRuleConfiguration> conditions = new ArrayList<WorkflowRuleConfiguration>();
    @JsonProperty(value="operation")
    private OperationEnum operation;

    public ConditionGroupUpdate conditionGroups(List<ConditionGroupUpdate> conditionGroups) {
        this.conditionGroups = conditionGroups;
        return this;
    }

    public ConditionGroupUpdate addConditionGroupsItem(ConditionGroupUpdate conditionGroupsItem) {
        if (this.conditionGroups == null) {
            this.conditionGroups = new ArrayList<ConditionGroupUpdate>();
        }
        this.conditionGroups.add(conditionGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The nested conditions of the condition group.")
    public List<ConditionGroupUpdate> getConditionGroups() {
        return this.conditionGroups;
    }

    public void setConditionGroups(List<ConditionGroupUpdate> conditionGroups) {
        this.conditionGroups = conditionGroups;
    }

    public ConditionGroupUpdate conditions(List<WorkflowRuleConfiguration> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ConditionGroupUpdate addConditionsItem(WorkflowRuleConfiguration conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<WorkflowRuleConfiguration>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="The rules for this condition.")
    public List<WorkflowRuleConfiguration> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<WorkflowRuleConfiguration> conditions) {
        this.conditions = conditions;
    }

    public ConditionGroupUpdate operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionGroupUpdate conditionGroupUpdate = (ConditionGroupUpdate)o;
        return Objects.equals(this.conditionGroups, conditionGroupUpdate.conditionGroups) && Objects.equals(this.conditions, conditionGroupUpdate.conditions) && Objects.equals((Object)this.operation, (Object)conditionGroupUpdate.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditionGroups, this.conditions, this.operation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionGroupUpdate {\n");
        sb.append("    conditionGroups: ").append(this.toIndentedString(this.conditionGroups)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        ANY("ANY"),
        ALL("ALL");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

