/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.ChangeDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.HistoryMetadata;
import org.everit.atlassian.restclient.jiracloud.v3.model.UserDetails;

@ApiModel(description="A log of changes made to issue fields. Changelogs related to workflow associations are currently being deprecated.")
public class Changelog {
    @JsonProperty(value="author")
    private UserDetails author;
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="historyMetadata")
    private HistoryMetadata historyMetadata;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="items")
    private List<ChangeDetails> items = new ArrayList<ChangeDetails>();

    @ApiModelProperty(value="The user who made the change.")
    public UserDetails getAuthor() {
        return this.author;
    }

    @ApiModelProperty(value="The date on which the change took place.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The history metadata associated with the changed.")
    public HistoryMetadata getHistoryMetadata() {
        return this.historyMetadata;
    }

    @ApiModelProperty(value="The ID of the changelog.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The list of items changed.")
    public List<ChangeDetails> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changelog changelog = (Changelog)o;
        return Objects.equals(this.author, changelog.author) && Objects.equals(this.created, changelog.created) && Objects.equals(this.historyMetadata, changelog.historyMetadata) && Objects.equals(this.id, changelog.id) && Objects.equals(this.items, changelog.items);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.created, this.historyMetadata, this.id, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Changelog {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    historyMetadata: ").append(this.toIndentedString(this.historyMetadata)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

