/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.BulkChangeOwnerDetails;
import org.everit.atlassian.restclient.jiracloud.v3.model.PermissionDetails;

@ApiModel(description="Details of a request to bulk edit shareable entity.")
public class BulkEditShareableEntityRequest {
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonProperty(value="changeOwnerDetails")
    private BulkChangeOwnerDetails changeOwnerDetails;
    @JsonProperty(value="entityIds")
    private List<Long> entityIds = new ArrayList<Long>();
    @JsonProperty(value="extendAdminPermissions")
    private Boolean extendAdminPermissions;
    @JsonProperty(value="permissionDetails")
    private PermissionDetails permissionDetails;

    public BulkEditShareableEntityRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="Allowed action for bulk edit shareable entity")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public BulkEditShareableEntityRequest changeOwnerDetails(BulkChangeOwnerDetails changeOwnerDetails) {
        this.changeOwnerDetails = changeOwnerDetails;
        return this;
    }

    @ApiModelProperty(value="The details of change owner action.")
    public BulkChangeOwnerDetails getChangeOwnerDetails() {
        return this.changeOwnerDetails;
    }

    public void setChangeOwnerDetails(BulkChangeOwnerDetails changeOwnerDetails) {
        this.changeOwnerDetails = changeOwnerDetails;
    }

    public BulkEditShareableEntityRequest entityIds(List<Long> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    public BulkEditShareableEntityRequest addEntityIdsItem(Long entityIdsItem) {
        this.entityIds.add(entityIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The id list of shareable entities to be changed.")
    public List<Long> getEntityIds() {
        return this.entityIds;
    }

    public void setEntityIds(List<Long> entityIds) {
        this.entityIds = entityIds;
    }

    public BulkEditShareableEntityRequest extendAdminPermissions(Boolean extendAdminPermissions) {
        this.extendAdminPermissions = extendAdminPermissions;
        return this;
    }

    @ApiModelProperty(value="Whether the actions are executed by users with Administer Jira global permission.")
    public Boolean getExtendAdminPermissions() {
        return this.extendAdminPermissions;
    }

    public void setExtendAdminPermissions(Boolean extendAdminPermissions) {
        this.extendAdminPermissions = extendAdminPermissions;
    }

    public BulkEditShareableEntityRequest permissionDetails(PermissionDetails permissionDetails) {
        this.permissionDetails = permissionDetails;
        return this;
    }

    @ApiModelProperty(value="The permission details to be changed.")
    public PermissionDetails getPermissionDetails() {
        return this.permissionDetails;
    }

    public void setPermissionDetails(PermissionDetails permissionDetails) {
        this.permissionDetails = permissionDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkEditShareableEntityRequest bulkEditShareableEntityRequest = (BulkEditShareableEntityRequest)o;
        return Objects.equals((Object)this.action, (Object)bulkEditShareableEntityRequest.action) && Objects.equals(this.changeOwnerDetails, bulkEditShareableEntityRequest.changeOwnerDetails) && Objects.equals(this.entityIds, bulkEditShareableEntityRequest.entityIds) && Objects.equals(this.extendAdminPermissions, bulkEditShareableEntityRequest.extendAdminPermissions) && Objects.equals(this.permissionDetails, bulkEditShareableEntityRequest.permissionDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.changeOwnerDetails, this.entityIds, this.extendAdminPermissions, this.permissionDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkEditShareableEntityRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    changeOwnerDetails: ").append(this.toIndentedString(this.changeOwnerDetails)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("    extendAdminPermissions: ").append(this.toIndentedString(this.extendAdminPermissions)).append("\n");
        sb.append("    permissionDetails: ").append(this.toIndentedString(this.permissionDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        CHANGEOWNER("changeOwner"),
        CHANGEPERMISSION("changePermission"),
        ADDPERMISSION("addPermission"),
        REMOVEPERMISSION("removePermission");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

