/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The Atlassian provided system rules available.")
public class AvailableWorkflowSystemRule {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="incompatibleRuleKeys")
    private List<String> incompatibleRuleKeys = new ArrayList<String>();
    @JsonProperty(value="isAvailableForInitialTransition")
    private Boolean isAvailableForInitialTransition;
    @JsonProperty(value="isVisible")
    private Boolean isVisible;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="ruleKey")
    private String ruleKey;
    @JsonProperty(value="ruleType")
    private RuleTypeEnum ruleType;

    public AvailableWorkflowSystemRule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AvailableWorkflowSystemRule incompatibleRuleKeys(List<String> incompatibleRuleKeys) {
        this.incompatibleRuleKeys = incompatibleRuleKeys;
        return this;
    }

    public AvailableWorkflowSystemRule addIncompatibleRuleKeysItem(String incompatibleRuleKeysItem) {
        this.incompatibleRuleKeys.add(incompatibleRuleKeysItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of rules that conflict with this one.")
    public List<String> getIncompatibleRuleKeys() {
        return this.incompatibleRuleKeys;
    }

    public void setIncompatibleRuleKeys(List<String> incompatibleRuleKeys) {
        this.incompatibleRuleKeys = incompatibleRuleKeys;
    }

    public AvailableWorkflowSystemRule isAvailableForInitialTransition(Boolean isAvailableForInitialTransition) {
        this.isAvailableForInitialTransition = isAvailableForInitialTransition;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the rule can be added added to an initial transition.")
    public Boolean getIsAvailableForInitialTransition() {
        return this.isAvailableForInitialTransition;
    }

    public void setIsAvailableForInitialTransition(Boolean isAvailableForInitialTransition) {
        this.isAvailableForInitialTransition = isAvailableForInitialTransition;
    }

    public AvailableWorkflowSystemRule isVisible(Boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the rule is visible.")
    public Boolean getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(Boolean isVisible) {
        this.isVisible = isVisible;
    }

    public AvailableWorkflowSystemRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AvailableWorkflowSystemRule ruleKey(String ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule key.")
    public String getRuleKey() {
        return this.ruleKey;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public AvailableWorkflowSystemRule ruleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @ApiModelProperty(required=true, value="The rule type.")
    public RuleTypeEnum getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleTypeEnum ruleType) {
        this.ruleType = ruleType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableWorkflowSystemRule availableWorkflowSystemRule = (AvailableWorkflowSystemRule)o;
        return Objects.equals(this.description, availableWorkflowSystemRule.description) && Objects.equals(this.incompatibleRuleKeys, availableWorkflowSystemRule.incompatibleRuleKeys) && Objects.equals(this.isAvailableForInitialTransition, availableWorkflowSystemRule.isAvailableForInitialTransition) && Objects.equals(this.isVisible, availableWorkflowSystemRule.isVisible) && Objects.equals(this.name, availableWorkflowSystemRule.name) && Objects.equals(this.ruleKey, availableWorkflowSystemRule.ruleKey) && Objects.equals((Object)this.ruleType, (Object)availableWorkflowSystemRule.ruleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.incompatibleRuleKeys, this.isAvailableForInitialTransition, this.isVisible, this.name, this.ruleKey, this.ruleType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableWorkflowSystemRule {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    incompatibleRuleKeys: ").append(this.toIndentedString(this.incompatibleRuleKeys)).append("\n");
        sb.append("    isAvailableForInitialTransition: ").append(this.toIndentedString(this.isAvailableForInitialTransition)).append("\n");
        sb.append("    isVisible: ").append(this.toIndentedString(this.isVisible)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ruleKey: ").append(this.toIndentedString(this.ruleKey)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RuleTypeEnum {
        CONDITION("Condition"),
        VALIDATOR("Validator"),
        FUNCTION("Function"),
        SCREEN("Screen");

        private String value;

        private RuleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RuleTypeEnum fromValue(String value) {
            for (RuleTypeEnum b : RuleTypeEnum.values()) {
                if (!b.value.equalsIgnoreCase(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

