/*
 * Decompiled with CFR 0.152.
 */
package org.everit.atlassian.restclient.jiracloud.v3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.everit.atlassian.restclient.jiracloud.v3.model.AssociatedItemBean;
import org.everit.atlassian.restclient.jiracloud.v3.model.ChangedValueBean;

@ApiModel(description="An audit record.")
public class AuditRecordBean {
    @JsonProperty(value="associatedItems")
    private List<AssociatedItemBean> associatedItems = new ArrayList<AssociatedItemBean>();
    @JsonProperty(value="authorKey")
    private String authorKey;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="changedValues")
    private List<ChangedValueBean> changedValues = new ArrayList<ChangedValueBean>();
    @JsonProperty(value="created")
    private OffsetDateTime created;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="eventSource")
    private String eventSource;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="objectItem")
    private AssociatedItemBean objectItem;
    @JsonProperty(value="remoteAddress")
    private String remoteAddress;
    @JsonProperty(value="summary")
    private String summary;

    @ApiModelProperty(value="The list of items associated with the changed record.")
    public List<AssociatedItemBean> getAssociatedItems() {
        return this.associatedItems;
    }

    @ApiModelProperty(value="Deprecated, use `authorAccountId` instead. The key of the user who created the audit record.")
    public String getAuthorKey() {
        return this.authorKey;
    }

    @ApiModelProperty(value="The category of the audit record. For a list of these categories, see the help article [Auditing in Jira applications](https://confluence.atlassian.com/x/noXKM).")
    public String getCategory() {
        return this.category;
    }

    @ApiModelProperty(value="The list of values changed in the record event.")
    public List<ChangedValueBean> getChangedValues() {
        return this.changedValues;
    }

    @ApiModelProperty(value="The date and time on which the audit record was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @ApiModelProperty(value="The description of the audit record.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The event the audit record originated from.")
    public String getEventSource() {
        return this.eventSource;
    }

    @ApiModelProperty(value="The ID of the audit record.")
    public Long getId() {
        return this.id;
    }

    public AuditRecordBean objectItem(AssociatedItemBean objectItem) {
        this.objectItem = objectItem;
        return this;
    }

    @ApiModelProperty(value="")
    public AssociatedItemBean getObjectItem() {
        return this.objectItem;
    }

    public void setObjectItem(AssociatedItemBean objectItem) {
        this.objectItem = objectItem;
    }

    @ApiModelProperty(value="The URL of the computer where the creation of the audit record was initiated.")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @ApiModelProperty(value="The summary of the audit record.")
    public String getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditRecordBean auditRecordBean = (AuditRecordBean)o;
        return Objects.equals(this.associatedItems, auditRecordBean.associatedItems) && Objects.equals(this.authorKey, auditRecordBean.authorKey) && Objects.equals(this.category, auditRecordBean.category) && Objects.equals(this.changedValues, auditRecordBean.changedValues) && Objects.equals(this.created, auditRecordBean.created) && Objects.equals(this.description, auditRecordBean.description) && Objects.equals(this.eventSource, auditRecordBean.eventSource) && Objects.equals(this.id, auditRecordBean.id) && Objects.equals(this.objectItem, auditRecordBean.objectItem) && Objects.equals(this.remoteAddress, auditRecordBean.remoteAddress) && Objects.equals(this.summary, auditRecordBean.summary);
    }

    public int hashCode() {
        return Objects.hash(this.associatedItems, this.authorKey, this.category, this.changedValues, this.created, this.description, this.eventSource, this.id, this.objectItem, this.remoteAddress, this.summary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditRecordBean {\n");
        sb.append("    associatedItems: ").append(this.toIndentedString(this.associatedItems)).append("\n");
        sb.append("    authorKey: ").append(this.toIndentedString(this.authorKey)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    changedValues: ").append(this.toIndentedString(this.changedValues)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    eventSource: ").append(this.toIndentedString(this.eventSource)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    objectItem: ").append(this.toIndentedString(this.objectItem)).append("\n");
        sb.append("    remoteAddress: ").append(this.toIndentedString(this.remoteAddress)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

